/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.komodo.spi.runtime.ConnectionDriver;
import org.komodo.spi.runtime.TeiidAdminInfo;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.spi.runtime.TeiidJdbcInfo;
import org.komodo.spi.runtime.TeiidParent;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersionProvider;
import org.komodo.teiid.impl.TeiidInstanceImpl;
import org.komodo.test.utils.DummyEventManager;
import org.komodo.test.utils.TestUtilities;
import org.komodo.utils.FileUtils;
import org.mockito.Mockito;
import org.teiid.adminapi.AdminProcessingException;

@RunWith(value=Arquillian.class)
public class TestTeiidInstance {
    private TeiidInstance teiidInstance;

    private TeiidInstance createTeiidInstance(TeiidParent parent, TeiidVersion teiidVersion, TeiidJdbcInfo jdbcInfo) throws Exception {
        return new TeiidInstanceImpl(parent, teiidVersion, jdbcInfo);
    }

    private TeiidVersion getVersion() {
        return DefaultTeiidVersion.Version.DEFAULT_TEIID_VERSION.get();
    }

    public TeiidInstance getTeiidInstance() {
        return this.teiidInstance;
    }

    @Before
    public void setup() throws Exception {
        DummyEventManager eventMgr = new DummyEventManager();
        TeiidParent parent = (TeiidParent)Mockito.mock(TeiidParent.class);
        Mockito.when((Object)parent.getHost()).thenReturn((Object)"localhost");
        Mockito.when((Object)parent.getUsername()).thenReturn((Object)"admin");
        Mockito.when((Object)parent.getPassword()).thenReturn((Object)"admin");
        Mockito.when((Object)parent.getPort()).thenReturn((Object)TeiidAdminInfo.Util.defaultPort((TeiidVersion)this.getVersion()));
        Mockito.when((Object)parent.getEventManager()).thenReturn((Object)eventMgr);
        TeiidJdbcInfo jdbcInfo = (TeiidJdbcInfo)Mockito.mock(TeiidJdbcInfo.class);
        Mockito.when((Object)jdbcInfo.getHostProvider()).thenReturn((Object)parent);
        Mockito.when((Object)jdbcInfo.getUsername()).thenReturn((Object)"user");
        Mockito.when((Object)jdbcInfo.getPassword()).thenReturn((Object)"user");
        Mockito.when((Object)jdbcInfo.getPort()).thenReturn((Object)31000);
        Mockito.when((Object)jdbcInfo.isSecure()).thenReturn((Object)true);
        this.teiidInstance = this.createTeiidInstance(parent, this.getVersion(), jdbcInfo);
    }

    @After
    public void teardown() throws Exception {
        if (this.teiidInstance != null) {
            this.teiidInstance.disconnect();
            this.teiidInstance = null;
        }
    }

    @Test
    public void testVersion() throws Exception {
        TeiidVersion version = this.teiidInstance.getVersion();
        Assert.assertEquals((Object)this.getVersion(), (Object)version);
    }

    @Test
    public void testConnection() throws Exception {
        this.teiidInstance.connect();
        Assert.assertTrue((boolean)this.teiidInstance.isConnected());
    }

    @Test
    public void testCreateDataSource() throws Exception {
        String displayName = "h2-connector";
        String type = "h2";
        String dsName = "accounts-ds";
        String jndiName = "java:/accounts-ds";
        String connUrl = "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1";
        if (this.teiidInstance.dataSourceExists(dsName)) {
            this.teiidInstance.deleteDataSource(dsName);
        }
        Properties properties = new Properties();
        properties.setProperty("jndi-name", jndiName);
        properties.setProperty("connection-url", connUrl);
        TeiidDataSource accountsDS = this.teiidInstance.getOrCreateDataSource(displayName, dsName, type, properties);
        Assert.assertNotNull((Object)accountsDS);
        Assert.assertEquals((Object)dsName, (Object)accountsDS.getName());
        Assert.assertEquals((Object)type, (Object)accountsDS.getType());
        Assert.assertEquals((Object)jndiName, (Object)accountsDS.getPropertyValue("jndi-name"));
        Assert.assertEquals((Object)connUrl, (Object)accountsDS.getPropertyValue("connection-url"));
        this.teiidInstance.deleteDataSource(dsName);
        Assert.assertFalse((boolean)this.teiidInstance.dataSourceExists(dsName));
    }

    @Test
    public void testDeployment() throws Exception {
        this.teiidInstance.deployDynamicVdb("sample-vdb.xml", TestUtilities.sampleExample());
        Thread.sleep(2000L);
        Collection vdbs = this.teiidInstance.getVdbs();
        Assert.assertEquals((long)1L, (long)vdbs.size());
        TeiidVdb vdb = this.teiidInstance.getVdb("sample");
        Assert.assertNotNull((Object)vdb);
        Assert.assertEquals((long)0L, (long)vdb.getValidityErrors().size());
        Assert.assertTrue((boolean)vdb.isActive());
        this.teiidInstance.undeployDynamicVdb("sample");
        vdbs = this.teiidInstance.getVdbs();
        Assert.assertEquals((long)0L, (long)vdbs.size());
    }

    private void wait(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TeiidDataSource deployDataSource() throws Exception {
        String displayName = "MySqlPool";
        String jndiName = "java:/MySqlDS";
        String typeName = "mysql-connector_com.mysql.jdbc.Driver_5_1";
        Properties properties = new Properties();
        properties.setProperty("password", "XUMz4vBKuA2v");
        properties.setProperty("user-name", "komodo");
        properties.setProperty("validate-on-match", "false");
        properties.setProperty("connection-url", "jdbc:mysql://db4free.net:3306/usstates");
        properties.setProperty("jndi-name", "java:/MySqlDS");
        properties.setProperty("driver-name", "mysql-connector-java-5.1.39-bin.jar_com.mysql.jdbc.Driver_5_1");
        TeiidDataSource teiidDataSource = this.getTeiidInstance().getOrCreateDataSource(displayName, jndiName, typeName, properties);
        Assert.assertNotNull((Object)teiidDataSource);
        return teiidDataSource;
    }

    @Test
    @Ignore(value="Test demonstrates TEIID-4592 / 3834. Question when it will be fixed for Teiid 9.1+")
    public void testDataSourceOperations() throws Exception {
        this.getTeiidInstance().connect();
        Assert.assertTrue((boolean)this.getTeiidInstance().isConnected());
        String MYSQL_DRIVER = "mysql-connector";
        InputStream driverStream = TestUtilities.mySqlDriver();
        Assert.assertNotNull((Object)driverStream);
        File driverFile = TestUtilities.createTempFile((String)MYSQL_DRIVER, (String)".jar");
        driverFile.deleteOnExit();
        FileUtils.write((InputStream)driverStream, (File)driverFile);
        this.getTeiidInstance().deployDriver(MYSQL_DRIVER, driverFile);
        this.wait(2);
        TeiidDataSource teiidDataSource = this.deployDataSource();
        Assert.assertTrue((boolean)this.getTeiidInstance().dataSourceExists(teiidDataSource.getName()));
        String dsName = teiidDataSource.getName();
        this.getTeiidInstance().deleteDataSource(dsName);
        this.wait(4);
        this.getTeiidInstance().reconnect();
        Assert.assertFalse((boolean)this.getTeiidInstance().dataSourceExists(dsName));
        try {
            teiidDataSource = this.deployDataSource();
            this.wait(4);
            this.getTeiidInstance().reconnect();
            Assert.assertTrue((boolean)this.getTeiidInstance().dataSourceExists(dsName));
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (this.getTeiidInstance().dataSourceExists(dsName)) {
                this.getTeiidInstance().deleteDataSource(dsName);
                this.wait(4);
            }
        }
    }

    @Test
    public void testDataSourceDrivers() throws Exception {
        this.getTeiidInstance().connect();
        Assert.assertTrue((boolean)this.getTeiidInstance().isConnected());
        Collection dataSourceDrivers = this.getTeiidInstance().getDataSourceDrivers();
        Assert.assertTrue((dataSourceDrivers.size() > 0 ? 1 : 0) != 0);
        String[] driverNamesArr = new String[]{"h2", "teiid-local", "teiid"};
        List<String> driverNames = Arrays.asList(driverNamesArr);
        String[] classNamesArr = new String[]{"org.teiid.jdbc.TeiidDriver", "org.h2.Driver"};
        List<String> classNames = Arrays.asList(classNamesArr);
        for (ConnectionDriver driver : dataSourceDrivers) {
            Assert.assertTrue((boolean)driverNames.contains(driver.getName()));
            Assert.assertTrue((boolean)classNames.contains(driver.getClassName()));
        }
    }

    @Test
    public void testRuntimeVersion() throws Exception {
        this.getTeiidInstance().connect();
        Assert.assertTrue((boolean)this.getTeiidInstance().isConnected());
        TeiidVersion version = this.getTeiidInstance().getRuntimeVersion();
        Assert.assertNotNull((Object)version);
        Assert.assertEquals((Object)TeiidVersionProvider.getInstance().getTeiidVersion(), (Object)version);
    }

    @Test
    public void testGetSchema() throws Exception {
        this.getTeiidInstance().connect();
        Assert.assertTrue((boolean)this.getTeiidInstance().isConnected());
        try {
            this.getTeiidInstance().getSchema("blah", "1.0", "model");
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof AdminProcessingException));
            Assert.assertTrue((boolean)cause.getMessage().contains("does not exist or is not ACTIVE"));
        }
    }
}

