/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.teiid.TeiidServiceProvider;

public class TestTeiidServiceProvider {
    @Test
    public void testSupportedVersions() throws Exception {
        TeiidVersion defaultVersion = DefaultTeiidVersion.Version.DEFAULT_TEIID_VERSION.get();
        Set versions = TeiidServiceProvider.getInstance().getSupportedTeiidVersions();
        for (TeiidVersion version : versions) {
            Assert.assertTrue((boolean)version.compareTo(defaultVersion));
        }
    }

    @Test
    public void testVersionsSupported() throws Exception {
        TeiidVersion defaultVersion = DefaultTeiidVersion.Version.DEFAULT_TEIID_VERSION.get();
        Assert.assertNotNull((Object)TeiidServiceProvider.getInstance().getTeiidService(defaultVersion));
        DefaultTeiidVersion microWildcardVersion = new DefaultTeiidVersion(defaultVersion.getMajor(), defaultVersion.getMinor(), "x");
        Assert.assertNotNull((Object)TeiidServiceProvider.getInstance().getTeiidService((TeiidVersion)microWildcardVersion));
        DefaultTeiidVersion zeroVersion = new DefaultTeiidVersion(defaultVersion.getMajor(), defaultVersion.getMinor(), "0");
        Assert.assertNotNull((Object)TeiidServiceProvider.getInstance().getTeiidService((TeiidVersion)zeroVersion));
    }
}

