/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid;

import org.komodo.spi.annotation.AnnotationUtils;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.type.DataTypeManager;

public abstract class AbstractDataTypeManager
implements DataTypeManager {
    private final TeiidVersion version;

    public AbstractDataTypeManager(TeiidVersion version) {
        this.version = version;
    }

    public TeiidVersion getVersion() {
        return this.version;
    }

    protected boolean isArrayType(String name) {
        return name.endsWith("[]");
    }

    protected String getComponentType(String name) {
        return name.substring(0, name.lastIndexOf("[]"));
    }

    public String getDataSourceType(DataTypeManager.DataSourceTypes dataSourceType) {
        if (dataSourceType == null) {
            return DataTypeManager.DataSourceTypes.UNKNOWN.id();
        }
        if (!AnnotationUtils.isApplicable((Enum)dataSourceType, (TeiidVersion)this.getVersion())) {
            return DataTypeManager.DataSourceTypes.UNKNOWN.id();
        }
        return AnnotationUtils.getUpdatedName((Enum)dataSourceType, (String)dataSourceType.id(), (TeiidVersion)this.getVersion());
    }

    public <T> T transformValue(Object value, DataTypeManager.DataTypeName dataTypeName) throws Exception {
        Class typeClass = dataTypeName.getDeclaringClass();
        return (T)this.transformValue(value, typeClass);
    }
}

