/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.query.StatementType;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.type.DataTypeManager;
import org.modeshape.jcr.api.Session;

public abstract class AbstractNodeGenerator<T>
implements StringConstants {
    private final Class<T> subjectClass;
    private final Node rootNode;
    private final DataTypeManager dataTypeManager;
    private final TeiidVersion version;
    private Map<IndexKey, Node> objectIndex;
    private Exception error = null;
    private Node parentNode;
    private String reference;

    protected static String toLowerCamelCase(String value) {
        if (value == null) {
            return null;
        }
        char[] c = value.toCharArray();
        if (c.length == 0) {
            return null;
        }
        for (int i = 0; i < c.length; ++i) {
            Character curr = Character.valueOf(c[i]);
            Character next = null;
            if (i + 1 < c.length) {
                next = Character.valueOf(c[i + 1]);
            }
            if (next == null) break;
            if (Character.isUpperCase(curr.charValue()) && Character.isUpperCase(next.charValue())) {
                c[i] = Character.toLowerCase(curr.charValue());
            }
            if (i == 0) {
                c[i] = Character.toLowerCase(curr.charValue());
            }
            if (!Character.isUpperCase(next.charValue())) break;
        }
        return new String(c);
    }

    protected IndexKey createKey(T obj, Node node) throws RepositoryException {
        return new IndexKey(obj, node);
    }

    protected Context localContext(Node parent, String reference) {
        return new Context(parent, reference);
    }

    public AbstractNodeGenerator(Class<T> subjectClass, Node parentNode, DataTypeManager dataTypeManager, TeiidVersion version) {
        this.subjectClass = subjectClass;
        this.rootNode = parentNode;
        this.dataTypeManager = dataTypeManager;
        this.version = version;
        this.parentNode = this.rootNode;
    }

    public TeiidVersion getVersion() {
        return this.version;
    }

    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    public boolean errorOccurred() {
        return this.error != null;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    protected String resolveCurrentPath(String jcrName) throws Exception {
        Session session = (Session)this.rootNode.getSession();
        if (jcrName.charAt(0) == "{".charAt(0) && jcrName.indexOf("}".charAt(0)) != -1) {
            int index = jcrName.indexOf("}".charAt(0));
            String localName = jcrName.substring(index + 1);
            localName = session.encode(localName);
            jcrName = jcrName.substring(0, index + 1) + localName;
        } else {
            jcrName = session.encode(jcrName);
        }
        return jcrName;
    }

    protected void index(T obj, Node node) throws RepositoryException {
        if (this.objectIndex == null) {
            this.objectIndex = new HashMap<IndexKey, Node>();
        }
        IndexKey key = this.createKey(obj, this.getParentNode());
        this.objectIndex.put(key, node);
    }

    protected Node node(T obj) throws RepositoryException {
        if (this.objectIndex == null) {
            return null;
        }
        IndexKey key = this.createKey(obj, this.getParentNode());
        return this.objectIndex.get(key);
    }

    protected Node create(Object obj) throws Exception {
        String jcrName = "tsql:" + AbstractNodeGenerator.toLowerCamelCase(obj.getClass().getSimpleName());
        String pathComponent = this.reference;
        if (this.reference == null) {
            pathComponent = jcrName;
        }
        Node node = null;
        String relativePath = this.resolveCurrentPath(pathComponent);
        node = this.parentNode.addNode(relativePath, "nt:unstructured");
        node.addMixin(jcrName);
        node.setProperty("tsql:teiidVersion", this.getVersion().toString());
        return node;
    }

    protected Node createTreeObject(T obj) throws Exception {
        Node node = this.node(obj);
        if (node != null) {
            return node;
        }
        node = this.create(obj);
        this.index(obj, node);
        return node;
    }

    protected Node transform(T obj) throws Exception {
        Node node = this.node(obj);
        if (node != null) {
            return node;
        }
        node = this.create(obj);
        this.index(obj, node);
        return node;
    }

    protected List<Value> convertToPropertyValues(Object objectValue, ValueFactory valueFactory) throws RepositoryException {
        ArrayList<Value> result = new ArrayList<Value>();
        if (objectValue instanceof Collection) {
            Collection objects = (Collection)objectValue;
            for (Object childObjectValue : objects) {
                List<Value> childValues = this.convertToPropertyValues(childObjectValue, valueFactory);
                result.addAll(childValues);
            }
        } else if (objectValue instanceof Boolean) {
            result.add(valueFactory.createValue(((Boolean)objectValue).booleanValue()));
        } else if (objectValue instanceof Integer) {
            result.add(valueFactory.createValue((long)((Integer)objectValue).intValue()));
        } else if (objectValue instanceof Long) {
            result.add(valueFactory.createValue(((Long)objectValue).longValue()));
        } else if (objectValue instanceof Double) {
            result.add(valueFactory.createValue(((Double)objectValue).doubleValue()));
        } else if (objectValue instanceof Float) {
            result.add(valueFactory.createValue((double)((Float)objectValue).floatValue()));
        } else if (this.subjectClass.isInstance(objectValue)) {
            result.add(valueFactory.createValue(this.node(this.subjectClass.cast(objectValue))));
        } else {
            result.add(valueFactory.createValue(objectValue.toString()));
        }
        return result;
    }

    protected void setProperty(Node node, String name, Object value) throws Exception {
        ValueFactory valueFactory = node.getSession().getValueFactory();
        if (value == null) {
            node.setProperty(name, (Value)null);
            return;
        }
        List<Value> valuesList = this.convertToPropertyValues(value, valueFactory);
        if (valuesList.size() == 1) {
            node.setProperty(name, valuesList.get(0));
        } else {
            node.setProperty(name, valuesList.toArray(new Value[0]));
        }
    }

    protected void setDataTypeProperty(Node node, String reference, Class<?> typeClass) throws Exception {
        DataTypeManager.DataTypeName dataTypeName = this.getDataTypeManager().retrieveDataTypeName(typeClass);
        this.setProperty(node, reference, dataTypeName.name());
    }

    protected void setStatementTypeProperty(Node node, int type) throws Exception {
        StatementType statementType = StatementType.findStatementType((int)type);
        if (statementType == null) {
            return;
        }
        this.setProperty(node, "tsql:type", statementType.name());
    }

    protected void visitObject(Node node, String reference, T obj) {
        Context context = this.localContext(node, reference);
        this.visitObject(obj);
        context.reset();
    }

    protected void visitObjects(Node node, String reference, T[] objs) {
        if (objs == null || objs.length == 0) {
            return;
        }
        Context context = this.localContext(node, reference);
        for (T obj : objs) {
            this.visitObject(obj);
        }
        context.reset();
    }

    protected void visitObjects(Node node, String reference, Collection<? extends T> objs) {
        if (objs == null || objs.size() == 0) {
            return;
        }
        Context context = this.localContext(node, reference);
        for (T obj : objs) {
            this.visitObject(obj);
        }
        context.reset();
    }

    public abstract void visitObject(T var1);

    protected class Context {
        private Node oldParent;
        private String oldReference;

        public Context(Node newParent, String newReference) {
            this.switchParent(newParent);
            this.switchReference(newReference);
        }

        private void switchParent(Node newParent) {
            this.oldParent = AbstractNodeGenerator.this.getParentNode();
            AbstractNodeGenerator.this.setParentNode(newParent);
        }

        private void switchReference(String newReference) {
            this.oldReference = AbstractNodeGenerator.this.getReference();
            AbstractNodeGenerator.this.setReference(newReference);
        }

        public void reset() {
            AbstractNodeGenerator.this.setParentNode(this.oldParent);
            AbstractNodeGenerator.this.setReference(this.oldReference);
        }
    }

    protected class IndexKey {
        private String parentPath;
        private T obj;

        public IndexKey(T obj, Node parent) throws RepositoryException {
            this.obj = obj;
            this.parentPath = parent == null ? "/" : parent.getPath();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.obj == null ? 0 : this.obj.hashCode());
            result = 31 * result + (this.parentPath == null ? 0 : this.parentPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexKey other = (IndexKey)obj;
            if (this.obj == null ? other.obj != null : !this.obj.equals(other.obj)) {
                return false;
            }
            return !(this.parentPath == null ? other.parentPath != null : !this.parentPath.equals(other.parentPath));
        }
    }
}

