/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.komodo.spi.query.QSColumn;
import org.komodo.spi.query.QSResult;
import org.komodo.spi.query.QSRow;
import org.komodo.spi.query.QueryService;
import org.komodo.spi.type.DataTypeManager;
import org.komodo.utils.KLog;

public abstract class AbstractQueryService
implements QueryService {
    private final DataTypeManager dataTypeManager;
    private final String user;
    private final String password;
    private final String host;
    private final int port;
    private final boolean secure;

    public AbstractQueryService(DataTypeManager dataTypeManager, String host, int port, String user, String password, boolean isSecure) {
        this.dataTypeManager = dataTypeManager;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.secure = isSecure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QSResult query(String vdb, String query, int offset, int limit) throws Exception {
        QSResult result = new QSResult();
        KLog.getLogger().debug("Commencing query execution: {0}", new Object[]{query});
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            KLog.getLogger().debug("Initialising SQL connection for vdb {0}", new Object[]{vdb});
            connection = this.getConnection(vdb, this.host, this.port, this.user, this.password, this.secure);
            if (connection == null) {
                throw new Exception("Failed to make a connection to '" + vdb + "' as user '" + this.user + "'");
            }
            statement = connection.createStatement();
            KLog.getLogger().debug("Executing SQL Statement for query {0} with offset of {1} and limit of {2}", new Object[]{query, offset, limit});
            rs = statement.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columns = rsmd.getColumnCount();
            for (int i = 1; i <= columns; ++i) {
                String columnName = rsmd.getColumnName(i);
                String columnLabel = rsmd.getColumnLabel(i);
                String colTypeName = rsmd.getColumnTypeName(i);
                DataTypeManager.DataTypeName typeName = this.dataTypeManager.getDataTypeName(colTypeName);
                QSColumn column = new QSColumn(typeName, columnName, columnLabel);
                result.addColumn(column);
            }
            int rowNum = 0;
            while (rs.next()) {
                if (offset > 0 && ++rowNum < offset) continue;
                if (limit > -1 && result.getRows().size() >= limit) break;
                QSRow row = new QSRow();
                for (int i = 1; i <= columns; ++i) {
                    Object value = rs.getObject(i);
                    row.add(value);
                }
                result.addRow(row);
            }
            KLog.getLogger().debug("Query executed and returning {0} results", new Object[]{result.getRows().size()});
            QSResult qSResult = result;
            return qSResult;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected abstract Connection getConnection(String var1, String var2, int var3, String var4, String var5, boolean var6) throws Exception;
}

