/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.outcome.Outcome;
import org.komodo.spi.outcome.OutcomeFactory;
import org.komodo.spi.runtime.ConnectionDriver;
import org.komodo.spi.runtime.EventManager;
import org.komodo.spi.runtime.ExecutionAdmin;
import org.komodo.spi.runtime.ExecutionConfigurationEvent;
import org.komodo.spi.runtime.HostProvider;
import org.komodo.spi.runtime.TeiidAdminInfo;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.spi.runtime.TeiidJdbcInfo;
import org.komodo.spi.runtime.TeiidParent;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.teiid.AbstractConnectionManager;
import org.komodo.teiid.Messages;
import org.komodo.utils.ArgCheck;
import org.komodo.utils.KLog;
import org.teiid.core.util.ApplicationInfo;

public abstract class AbstractTeiidInstance
implements TeiidInstance,
StringConstants {
    protected static final String TEST_VDB = "<vdb name=\"ping\" version=\"1\"><model visible=\"true\" name=\"Foo\" type=\"PHYSICAL\" path=\"/dummy/Foo\"><source name=\"s\" translator-name=\"loopback\"/><metadata type=\"DDL\"><![CDATA[CREATE FOREIGN TABLE G1 (e1 string, e2 integer);]]> </metadata></model></vdb>";
    private final JndiManager manager = new JndiManager();
    private TeiidParent parent;
    private TeiidAdminInfo adminInfo;
    private TeiidJdbcInfo jdbcInfo;
    private TeiidVersion supportedVersion;
    private String connectionError;

    public AbstractTeiidInstance(TeiidParent parent, TeiidVersion teiidVersion, TeiidJdbcInfo jdbcInfo) {
        ArgCheck.isNotNull((Object)parent);
        ArgCheck.isNotNull((Object)jdbcInfo);
        ArgCheck.isNotNull((Object)parent);
        this.parent = parent;
        this.supportedVersion = teiidVersion;
        this.adminInfo = new TeiidAdminInfoImpl();
        this.jdbcInfo = jdbcInfo;
    }

    protected abstract AbstractConnectionManager getConnectionManager();

    public boolean isSound() {
        if (this.getParent() == null) {
            return false;
        }
        if (this.getTeiidAdminInfo() == null) {
            return false;
        }
        if (this.getTeiidJdbcInfo() == null) {
            return false;
        }
        return this.getParent().isSound();
    }

    protected String appendVdbExtension(String vdbName) {
        if (vdbName.endsWith("vdb")) {
            return vdbName;
        }
        return vdbName + ".vdb";
    }

    protected String appendDynamicVdbSuffix(String vdbName) {
        if (vdbName.endsWith("-vdb.xml")) {
            return vdbName;
        }
        return vdbName + "-vdb.xml";
    }

    public TeiidParent getParent() {
        return this.parent;
    }

    public TeiidAdminInfo getTeiidAdminInfo() {
        return this.adminInfo;
    }

    protected String getVdbDataSourceConnectionUrl(String vdbName) {
        String host = this.adminInfo.getHostProvider().getHost();
        int port = this.adminInfo.getPort();
        return "jdbc:teiid:" + vdbName + "@mm://" + host + ':' + port;
    }

    public TeiidJdbcInfo getTeiidJdbcInfo() {
        return this.jdbcInfo;
    }

    public String getParentName() {
        return this.parent.getName();
    }

    public TeiidVersion getSupportedVersion() {
        return this.supportedVersion;
    }

    public TeiidVersion getClientVersion() {
        return new DefaultTeiidVersion(ApplicationInfo.getInstance().getBuildNumber());
    }

    public abstract TeiidVersion getRuntimeVersion() throws Exception;

    public TeiidVersion getVersion() {
        if (this.isConnected()) {
            try {
                TeiidVersion version = this.getRuntimeVersion();
                if (version != null) {
                    return version;
                }
            }
            catch (Exception ex) {
                KLog.getLogger().error(ex.getMessage(), (Throwable)ex, new Object[0]);
            }
        }
        return this.getClientVersion();
    }

    public String getConnectionError() {
        return this.connectionError;
    }

    protected void setConnectionError(String connectionError) {
        this.connectionError = connectionError;
    }

    public EventManager getEventManager() {
        return this.getParent().getEventManager();
    }

    public String getHost() {
        return this.getParent().getHost();
    }

    public String getId() {
        return this.getUrl() + "-" + this.getParent().getId();
    }

    public String getUrl() {
        return this.getTeiidJdbcInfo().getUrl();
    }

    public void notifyRefresh() {
        if (this.getEventManager() == null) {
            return;
        }
        this.getEventManager().notifyListeners(ExecutionConfigurationEvent.createTeiidRefreshEvent((TeiidInstance)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParentConnected() {
        boolean socketReader2;
        Socket socket = null;
        Reader in = null;
        InetSocketAddress endPoint = new InetSocketAddress(this.parent.getHost(), this.parent.getPort());
        if (endPoint.isUnresolved()) {
            return false;
        }
        try {
            socket = new Socket();
            socket.connect(endPoint, 1024);
            if (this.getClientVersion().isLessThan(DefaultTeiidVersion.Version.TEIID_9_1)) {
                char[] buffer;
                InputStream socketReader2 = socket.getInputStream();
                in = new InputStreamReader(socketReader2);
                int rsz = in.read(buffer = new char[100], 0, buffer.length);
                if (rsz == -1) {
                    boolean bl = false;
                    return bl;
                }
                StringBuffer output = new StringBuffer();
                for (int i = 0; i < buffer.length; ++i) {
                    if (!Character.isLetterOrDigit(buffer[i])) continue;
                    output.append(buffer[i]);
                }
            }
            socketReader2 = true;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (socket != null && socket.isConnected()) {
                    socket.close();
                    socket = null;
                }
            }
            catch (Exception exception) {}
        }
        return socketReader2;
    }

    public void reconnect() {
        try {
            this.getEventManager().permitListeners(false);
            try {
                this.disconnect();
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                this.getEventManager().permitListeners(true);
            }
            if (!this.isParentConnected()) {
                throw new Exception(Messages.getString(Messages.TeiidInstance.parentNotStartedMessage, new Object[0]));
            }
            this.connect();
            this.setConnectionError(null);
        }
        catch (Exception e) {
            String msg = Messages.getString(Messages.TeiidInstance.reconnectErrorMsg, this) + "\n" + e.getLocalizedMessage();
            this.setConnectionError(msg);
        }
    }

    protected abstract Outcome pingAdmin() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Outcome pingJdbc() {
        Outcome outcome;
        block9: {
            TeiidJdbcInfo teiidJdbcInfo = this.getTeiidJdbcInfo();
            Connection teiidJdbcConnection = null;
            this.deploy("ping-vdb.xml", new ByteArrayInputStream(TEST_VDB.getBytes()));
            Thread.sleep(2000L);
            try {
                teiidJdbcConnection = this.getConnectionManager().getConnection("ping", this.getHost(), teiidJdbcInfo.getPort(), teiidJdbcInfo.getUsername(), teiidJdbcInfo.getPassword(), teiidJdbcInfo.isSecure());
                outcome = OutcomeFactory.getInstance().createOK();
                if (teiidJdbcConnection == null) break block9;
            }
            catch (Throwable ex) {
                Outcome outcome2;
                block10: {
                    try {
                        String msg = Messages.getString(Messages.ExecutionAdmin.instanceDeployUndeployProblemPingingTeiidJdbc, this.getUrl());
                        outcome2 = OutcomeFactory.getInstance().createError(msg, new Exception(ex));
                        if (teiidJdbcConnection == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (teiidJdbcConnection != null) {
                                teiidJdbcConnection.close();
                            }
                            this.undeploy("ping-vdb.xml");
                            throw throwable;
                        }
                        catch (Exception ex2) {
                            String msg = Messages.getString(Messages.ExecutionAdmin.instanceDeployUndeployProblemPingingTeiidJdbc, this.getUrl());
                            return OutcomeFactory.getInstance().createError(msg, ex2);
                        }
                    }
                    teiidJdbcConnection.close();
                }
                this.undeploy("ping-vdb.xml");
                return outcome2;
            }
            teiidJdbcConnection.close();
        }
        this.undeploy("ping-vdb.xml");
        return outcome;
    }

    protected abstract boolean isCoherent();

    public Outcome ping(ExecutionAdmin.ConnectivityType connectivityType) {
        try {
            boolean testCausesConnect = false;
            if (!this.isCoherent()) {
                this.connect();
                testCausesConnect = true;
            }
            Outcome outcome = null;
            String msg = Messages.getString(Messages.ExecutionAdmin.cannotConnectToServer, this.getTeiidAdminInfo().getUsername());
            if (!this.isCoherent()) {
                throw new Exception(msg);
            }
            switch (connectivityType) {
                case JDBC: {
                    outcome = this.pingJdbc();
                    break;
                }
                default: {
                    outcome = this.pingAdmin();
                }
            }
            if (testCausesConnect) {
                this.disconnect();
            }
            return outcome;
        }
        catch (Exception ex) {
            String msg = Messages.getString(Messages.ExecutionAdmin.cannotConnectToServer, this.getUrl());
            return OutcomeFactory.getInstance().createError(msg, ex);
        }
    }

    public Properties getDataSourceProperties(String name) throws Exception {
        this.connect();
        return this.getDataSource(name).getProperties();
    }

    public abstract Collection<ConnectionDriver> getDataSourceDrivers() throws Exception;

    private String getDSMatchForDriverClass(String requestDriverClass) throws Exception {
        if (requestDriverClass == null) {
            return null;
        }
        if (!this.isParentConnected()) {
            return null;
        }
        try {
            Collection<ConnectionDriver> dataSourceDrivers = this.getDataSourceDrivers();
            for (ConnectionDriver driver : dataSourceDrivers) {
                String driverClassName = driver.getClassName();
                String driverName = driver.getName();
                if (!requestDriverClass.equalsIgnoreCase(driverClassName)) continue;
                return driverName;
            }
        }
        catch (Exception ex) {
            KLog.getLogger().error(Messages.getString(Messages.ExecutionAdmin.failedToGetDriverMappings, requestDriverClass), (Throwable)ex, new Object[0]);
        }
        return null;
    }

    protected abstract void createDataSource(String var1, String var2, Properties var3) throws Exception;

    public TeiidDataSource getOrCreateDataSource(String displayName, String dsName, String typeName, Properties properties) throws Exception {
        TeiidDataSource tds;
        ArgCheck.isNotEmpty((String)displayName, (String)"displayName");
        ArgCheck.isNotEmpty((String)dsName, (String)"dsName");
        ArgCheck.isNotEmpty((String)typeName, (String)"typeName");
        ArgCheck.isNotEmpty((Map)properties, (String)"properties");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object value = entry.getValue();
            String errorMsg = "No value for the connection property '" + entry.getKey() + "'";
            ArgCheck.isNotNull((Object)value, (String)errorMsg);
            ArgCheck.isNotEmpty((String)value.toString(), (String)errorMsg);
        }
        this.connect();
        dsName = this.manager.getName(dsName);
        if (this.dataSourceExists(dsName) && (tds = this.getDataSource(dsName)) != null) {
            return tds;
        }
        String connProfileDriverClass = properties.getProperty("driverclass");
        if ("connectorjdbc".equals(typeName)) {
            String jarList = properties.getProperty("jarList");
            String dsNameMatch = this.getDSMatchForDriverClass(connProfileDriverClass);
            if (dsNameMatch != null) {
                typeName = dsNameMatch;
            } else if (jarList != null && jarList.trim().length() > 0) {
                this.deployJars(jarList);
                dsNameMatch = this.getDSMatchForDriverClass(connProfileDriverClass);
                if (dsNameMatch != null) {
                    typeName = dsNameMatch;
                }
            }
        }
        if (!this.getDataSourceTypeNames().contains(typeName)) {
            if ("connectorjdbc".equals(typeName)) {
                throw new Exception(Messages.getString(Messages.ExecutionAdmin.jdbcSourceForClassNameNotFound, connProfileDriverClass, this.getUrl()));
            }
            throw new Exception(Messages.getString(Messages.ExecutionAdmin.dataSourceTypeDoesNotExist, typeName, this.getUrl()));
        }
        properties.setProperty("display-name", displayName);
        this.createDataSource(dsName, typeName, properties);
        TeiidDataSource tds2 = this.getDataSource(dsName);
        if (tds2 != null) {
            this.getEventManager().notifyListeners(ExecutionConfigurationEvent.createAddDataSourceEvent((TeiidDataSource)tds2));
            return tds2;
        }
        throw new Exception(Messages.getString(Messages.ExecutionAdmin.errorCreatingDataSource, dsName, typeName));
    }

    public Outcome createVdbDataSource(String vdbName, String displayName, String jndiName) {
        Properties props = new Properties();
        String username = this.jdbcInfo.getUsername();
        String password = this.jdbcInfo.getPassword();
        if (username != null) {
            props.put("username", username);
        }
        if (password != null) {
            props.put("password", password);
        }
        props.put("driverclass", "org.teiid.jdbc.TeiidDriver");
        props.put("connectionurl", this.getVdbDataSourceConnectionUrl(vdbName));
        try {
            this.connect();
            this.getOrCreateDataSource(displayName, jndiName, "connectorjdbc", props);
        }
        catch (Exception ex) {
            String msg = "Error creating data source for VDB " + vdbName;
            return OutcomeFactory.getInstance().createError(msg, ex);
        }
        return OutcomeFactory.getInstance().createOK();
    }

    public boolean hasVdb(String name) throws Exception {
        this.connect();
        return this.getVdb(name) != null;
    }

    public boolean isVdbActive(String vdbName) throws Exception {
        this.connect();
        if (!this.hasVdb(vdbName)) {
            return false;
        }
        return this.getVdb(vdbName).isActive();
    }

    public boolean isVdbLoading(String vdbName) throws Exception {
        this.connect();
        if (!this.hasVdb(vdbName)) {
            return false;
        }
        return this.getVdb(vdbName).isLoading();
    }

    public boolean hasVdbFailed(String vdbName) throws Exception {
        this.connect();
        if (!this.hasVdb(vdbName)) {
            return false;
        }
        return this.getVdb(vdbName).hasFailed();
    }

    public boolean wasVdbRemoved(String vdbName) throws Exception {
        this.connect();
        if (!this.hasVdb(vdbName)) {
            return false;
        }
        return this.getVdb(vdbName).wasRemoved();
    }

    public List<String> retrieveVdbValidityErrors(String vdbName) throws Exception {
        this.connect();
        if (!this.hasVdb(vdbName)) {
            return Collections.emptyList();
        }
        return this.getVdb(vdbName).getValidityErrors();
    }

    protected abstract void deploy(String var1, InputStream var2) throws Exception;

    public void deployDynamicVdb(String deploymentName, InputStream inStream) throws Exception {
        this.connect();
        ArgCheck.isNotNull((Object)deploymentName, (String)"deploymentName");
        ArgCheck.isNotNull((Object)inStream, (String)"inStream");
        this.deploy(deploymentName, inStream);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deployDriver(String driverName, File driverFile) throws Exception {
        this.connect();
        ArgCheck.isNotNull((Object)driverName, (String)"driverName");
        if (!driverFile.exists()) {
            throw new Exception(Messages.getString(Messages.ExecutionAdmin.jarDeploymentJarNotFound, driverFile.getPath()));
        }
        if (!driverFile.canRead()) {
            throw new Exception(Messages.getString(Messages.ExecutionAdmin.jarDeploymentJarNotReadable, driverFile.getPath()));
        }
        FileInputStream iStream = null;
        iStream = new FileInputStream(driverFile);
        this.deploy(driverName, iStream);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {}
    }

    public void undeployDriver(String driverName) throws Exception {
        this.connect();
        ArgCheck.isNotNull((Object)driverName, (String)"driverName");
        this.undeploy(driverName);
    }

    protected void deployJars(String jarList) throws Exception {
        String[] jarPathStrs;
        for (String jarPathStr : jarPathStrs = jarList.split("[:]")) {
            File theFile = new File(jarPathStr);
            if (!theFile.exists()) {
                throw new Exception(Messages.getString(Messages.ExecutionAdmin.jarDeploymentJarNotFound, theFile.getPath()));
            }
            if (!theFile.canRead()) {
                throw new Exception(Messages.getString(Messages.ExecutionAdmin.jarDeploymentJarNotReadable, theFile.getPath()));
            }
            String fileName = theFile.getName();
            FileInputStream iStream = null;
            try {
                iStream = new FileInputStream(theFile);
            }
            catch (FileNotFoundException ex) {
                continue;
            }
            try {
                this.deploy(fileName, iStream);
            }
            catch (Exception ex) {
                throw new Exception(Messages.getString(Messages.ExecutionAdmin.jarDeploymentFailed, theFile.getPath()), ex);
            }
        }
    }

    protected abstract void undeploy(String var1) throws Exception;

    public void undeployDynamicVdb(String vdbName) throws Exception {
        this.connect();
        TeiidVdb vdb = this.getVdb(vdbName);
        if (vdb != null) {
            this.undeploy(this.appendDynamicVdbSuffix(vdbName));
        }
        if ((vdb = this.getVdb(vdbName)) != null) {
            this.getEventManager().notifyListeners(ExecutionConfigurationEvent.createUnDeployVDBEvent((String)vdb.getName()));
        }
    }

    public void undeployVdb(String vdbName) throws Exception {
        this.connect();
        TeiidVdb vdb = this.getVdb(vdbName);
        if (vdb != null) {
            this.undeploy(this.appendVdbExtension(vdbName));
        }
        if ((vdb = this.getVdb(vdbName)) != null) {
            this.getEventManager().notifyListeners(ExecutionConfigurationEvent.createUnDeployVDBEvent((String)vdb.getName()));
        }
    }

    public void update(TeiidInstance otherInstance) {
        ArgCheck.isNotNull((Object)otherInstance);
        this.disconnect();
        this.connectionError = null;
        TeiidJdbcInfo otherJdbcInfo = otherInstance.getTeiidJdbcInfo();
        this.jdbcInfo.setHostProvider(otherJdbcInfo.getHostProvider());
        this.jdbcInfo.setPassword(otherJdbcInfo.getPassword());
        this.jdbcInfo.setUsername(otherJdbcInfo.getUsername());
        this.jdbcInfo.setPort(otherJdbcInfo.getPort());
        this.jdbcInfo.setSecure(otherJdbcInfo.isSecure());
    }

    protected class TeiidAdminInfoImpl
    implements TeiidAdminInfo {
        protected TeiidAdminInfoImpl() {
        }

        public HostProvider getHostProvider() {
            return AbstractTeiidInstance.this.parent;
        }

        public String getUsername() {
            return AbstractTeiidInstance.this.parent.getUsername();
        }

        public String getPassword() {
            return AbstractTeiidInstance.this.parent.getPassword();
        }

        public int getPort() {
            return AbstractTeiidInstance.this.parent.getPort();
        }

        public boolean isSecure() {
            return AbstractTeiidInstance.this.parent.isSecure();
        }

        public ExecutionAdmin.ConnectivityType getType() {
            return ExecutionAdmin.ConnectivityType.ADMIN;
        }

        public String getUrl() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.isSecure() ? "mms://" : "mm://");
            sb.append(this.getHostProvider().getHost());
            sb.append(':');
            sb.append(this.getPort());
            return sb.toString();
        }

        public void setHostProvider(HostProvider hostProvider) {
        }

        public void setPassword(String password) {
        }

        public void setPort(int port) {
        }

        public void setSecure(boolean secure) {
        }

        public void setUsername(String username) {
        }
    }

    protected class JndiManager
    implements StringConstants {
        private static final String PREFIX = "java:/";

        protected JndiManager() {
        }

        public String getName(String name) {
            if (!name.startsWith(PREFIX)) {
                return name;
            }
            if ((name = name.replace(PREFIX, "")).startsWith("/")) {
                name = name.substring(1);
            }
            return name;
        }
    }
}

