/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid;

import java.util.HashSet;
import java.util.Set;
import org.komodo.spi.query.TeiidService;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.teiid.UnsupportedTeiidException;
import org.komodo.teiid.impl.TeiidServiceImpl;

public class TeiidServiceProvider {
    private static TeiidServiceProvider instance;
    private TeiidService teiidService;

    public static TeiidServiceProvider getInstance() {
        if (instance == null) {
            instance = new TeiidServiceProvider();
        }
        return instance;
    }

    private void init() throws Exception {
        if (this.teiidService != null) {
            return;
        }
        this.teiidService = new TeiidServiceImpl();
        TeiidVersion runtimeVersion = this.teiidService.getVersion();
        if (!this.isSupportedTeiidVersion(runtimeVersion)) {
            throw new UnsupportedTeiidException(runtimeVersion);
        }
    }

    public void dispose() {
        if (this.teiidService != null) {
            this.teiidService.dispose();
            this.teiidService = null;
        }
    }

    public Set<TeiidVersion> getSupportedTeiidVersions() {
        TeiidVersion version = DefaultTeiidVersion.Version.DEFAULT_TEIID_VERSION.get();
        DefaultTeiidVersion wildcard = new DefaultTeiidVersion(version.getMajor(), version.getMinor(), "x");
        HashSet<TeiidVersion> versions = new HashSet<TeiidVersion>();
        versions.add(version);
        versions.add((TeiidVersion)wildcard);
        return versions;
    }

    public boolean isSupportedTeiidVersion(TeiidVersion teiidVersion) {
        for (TeiidVersion version : this.getSupportedTeiidVersions()) {
            if (!teiidVersion.compareTo(version)) continue;
            return true;
        }
        return false;
    }

    public TeiidService getTeiidService() throws Exception {
        this.init();
        return this.teiidService;
    }

    public synchronized TeiidService getTeiidService(TeiidVersion version) throws Exception {
        this.init();
        if (this.teiidService != null && this.isSupportedTeiidVersion(version)) {
            return this.teiidService;
        }
        throw new UnsupportedTeiidException(version);
    }

    public void setTeiidService(TeiidService teiidService) {
        this.teiidService = teiidService;
    }
}

