/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid.impl;

import java.util.Set;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.type.DataTypeManager;
import org.komodo.teiid.AbstractDataTypeManager;
import org.teiid.core.types.DataTypeManager;

public class DataTypeManagerImpl
extends AbstractDataTypeManager {
    public DataTypeManagerImpl(TeiidVersion version) {
        super(version);
    }

    public Class<?> getDataTypeClass(String name) {
        return DataTypeManager.getDataTypeClass((String)name);
    }

    public DataTypeManager.DataTypeName getDataTypeName(String dataTypeId) {
        DataTypeManager.DataTypeName dataType;
        if (dataTypeId == null) {
            return DataTypeManager.DataTypeName.NULL;
        }
        dataTypeId = DataTypeManager.DataTypeName.correctBigUnderscores((String)dataTypeId);
        Class<?> dataTypeClass = this.getDataTypeClass(dataTypeId);
        boolean isArray = this.isArrayType(dataTypeId = DataTypeManager.getDataTypeName(dataTypeClass));
        if (isArray) {
            dataTypeId = this.getComponentType(dataTypeId);
        }
        if ((dataType = DataTypeManager.DataTypeName.findDataTypeName((String)dataTypeId)) == null) {
            dataType = DataTypeManager.DataTypeName.OBJECT;
        }
        if (isArray) {
            return dataType.getArrayType();
        }
        return dataType;
    }

    public String getDataTypeName(Class<?> typeClass) {
        return DataTypeManager.getDataTypeName(typeClass);
    }

    public DataTypeManager.DataTypeName retrieveDataTypeName(Class<?> typeClass) {
        String typeName = this.getDataTypeName(typeClass);
        return DataTypeManager.DataTypeName.findDataTypeName((String)typeName);
    }

    public Set<String> getAllDataTypeNames() {
        return DataTypeManager.getAllDataTypeNames();
    }

    public Class<?> getDefaultDataClass(DataTypeManager.DataTypeName dataTypeName) {
        if (dataTypeName == null) {
            return this.getDataTypeClass(null);
        }
        return this.getDataTypeClass(dataTypeName.name());
    }

    public boolean isExplicitConversion(String sourceTypeName, String targetTypeName) {
        return DataTypeManager.isExplicitConversion((String)sourceTypeName, (String)targetTypeName);
    }

    public boolean isImplicitConversion(String sourceTypeName, String targetTypeName) {
        return DataTypeManager.isImplicitConversion((String)sourceTypeName, (String)targetTypeName);
    }

    public boolean isTransformable(String sourceTypeName, String targetTypeName) {
        return DataTypeManager.isTransformable((String)sourceTypeName, (String)targetTypeName);
    }

    public boolean isLOB(Class<?> type) {
        return DataTypeManager.isLOB(type);
    }

    public <T> T transformValue(Object value, Class<?> typeClass) throws Exception {
        return (T)DataTypeManager.transformValue((Object)value, typeClass);
    }
}

