/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.komodo.spi.runtime.ConnectionDriver;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.teiid.ExtensionConstants;
import org.komodo.teiid.Messages;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.jboss.MetadataMapper;

public class JbossExtensions
implements ExtensionConstants {
    private Object getField(Admin admin, String fieldName) throws Exception {
        if (admin == null) {
            return null;
        }
        try {
            Field field = admin.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(admin);
        }
        catch (NoSuchFieldException ex) {
            throw new Exception(Messages.getString(Messages.TeiidInstance.noSuchField, fieldName));
        }
    }

    private boolean isDomainMode(Admin admin) throws Exception {
        if (admin == null) {
            return false;
        }
        Object domainMode = this.getField(admin, "domainMode");
        if (domainMode instanceof Boolean) {
            return (Boolean)domainMode;
        }
        return false;
    }

    private ModelControllerClient getConnection(Admin admin) throws Exception {
        if (admin == null) {
            throw new Exception("Client is not yet connected");
        }
        Object connection = this.getField(admin, "connection");
        if (connection instanceof ModelControllerClient) {
            return (ModelControllerClient)connection;
        }
        throw new Exception(Messages.getString(Messages.TeiidInstance.noSuchField, "connection"));
    }

    private List<String> getChildNodeNames(Admin admin, String subsystem, String childNode) throws Exception {
        ModelNode request = this.buildRequest(admin, subsystem, "read-children-names", "child-type", childNode);
        ModelNode outcome = this.getConnection(admin).execute(request);
        if (Util.isSuccess((ModelNode)outcome)) {
            return Util.getList((ModelNode)outcome);
        }
        return Collections.emptyList();
    }

    private String getProfileName(Admin admin) throws Exception {
        if (!this.isDomainMode(admin)) {
            return null;
        }
        return this.getChildNodeNames(admin, null, "profile").get(0);
    }

    private void addProfileNode(Admin admin, DefaultOperationRequestBuilder builder) throws Exception {
        if (!this.isDomainMode(admin)) {
            return;
        }
        String profile = this.getProfileName(admin);
        if (profile != null) {
            builder.addNode("profile", profile);
        }
    }

    private ModelNode buildRequest(Admin admin, String subsystem, String operationName, String ... params) throws Exception {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            if (subsystem != null) {
                this.addProfileNode(admin, builder);
                builder.addNode("subsystem", subsystem);
            }
            builder.setOperationName(operationName);
            request = builder.buildRequest();
            if (params != null && params.length % 2 == 0) {
                for (int i = 0; i < params.length; i += 2) {
                    builder.addProperty(params[i], params[i + 1]);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(Messages.getString(Messages.TeiidInstance.buildOperationFailure, operationName), e);
        }
        return request;
    }

    private <T> List<T> getList(ModelNode operationResult, MetadataMapper<T> mapper) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get("result").asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(mapper.unwrap(node));
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Collection<ConnectionDriver> getDataSourceDrivers(Admin admin) throws Exception {
        if (admin == null) {
            return Collections.emptyList();
        }
        HashSet<ConnectionDriver> dataSourceDrivers = new HashSet<ConnectionDriver>();
        if (!this.isDomainMode(admin)) {
            ModelNode request = this.buildRequest(admin, "datasources", "installed-drivers-list", new String[0]);
            ModelNode outcome = this.getConnection(admin).execute(request);
            if (Util.isSuccess((ModelNode)outcome)) {
                List<ConnectionDriver> drivers = this.getList(outcome, new MetadataMapper<ConnectionDriver>(){

                    public ConnectionDriver unwrap(ModelNode node) {
                        String driverName = null;
                        String driverClassName = null;
                        if (node.hasDefined("driver-name")) {
                            driverName = node.get("driver-name").asString();
                        }
                        if (node.hasDefined("driver-class-name")) {
                            driverClassName = node.get("driver-class-name").asString();
                        }
                        if (driverName == null || driverClassName == null) {
                            return null;
                        }
                        return new ConnectionDriver(driverName, driverClassName);
                    }

                    public ModelNode describe(ModelNode node) {
                        throw new UnsupportedOperationException();
                    }

                    public ModelNode wrap(ConnectionDriver obj, ModelNode node) {
                        throw new UnsupportedOperationException();
                    }
                });
                dataSourceDrivers.addAll(drivers);
                return dataSourceDrivers;
            }
            String msg = Messages.getString(Messages.TeiidInstance.requestDriverFailure, Util.getFailureDescription((ModelNode)outcome));
            throw new Exception(msg);
        }
        List<String> deployments = this.getChildNodeNames(admin, null, "deployment");
        Iterator<String> iterator = deployments.iterator();
        while (iterator.hasNext()) {
            String deployment = iterator.next();
            if (deployment.contains("translator") || !deployment.endsWith(".jar")) continue;
            dataSourceDrivers.add(new ConnectionDriver(deployment, deployment));
        }
        return dataSourceDrivers;
    }

    public TeiidVersion getTeiidRuntimeVersion(Admin admin) throws Exception {
        if (admin == null) {
            throw new Exception(Messages.getString(Messages.TeiidInstance.requestTeiidVersionFailure, new Object[0]));
        }
        ModelNode request = this.buildRequest(admin, "teiid", "read-attribute", "name", "runtime-version");
        ModelNode outcome = this.getConnection(admin).execute(request);
        if (Util.isSuccess((ModelNode)outcome)) {
            ModelNode result = outcome.get("result");
            String versionId = result.asString();
            return new DefaultTeiidVersion(versionId);
        }
        throw new Exception(Messages.getString(Messages.TeiidInstance.requestTeiidVersionFailure, new Object[0]));
    }
}

