/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.komodo.spi.constants.StringConstants;
import org.komodo.spi.query.CriteriaOperator;
import org.komodo.spi.query.JoinTypeTypes;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.type.DataTypeManager;
import org.komodo.teiid.AbstractNodeGenerator;
import org.teiid.language.Like;
import org.teiid.language.SortSpecification;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsDistinctCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.BranchingStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.ExceptionExpression;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.RaiseStatement;
import org.teiid.query.sql.proc.ReturnStatement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.JSONObject;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.WindowSpecification;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLCast;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLExists;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.translator.CacheDirective;

public class NodeGenerator
extends AbstractNodeGenerator<LanguageObject>
implements StringConstants {
    private final NodeVisitor nodeVisitor = new NodeVisitor();

    public NodeGenerator(Node parentNode, DataTypeManager dataTypeManager, TeiidVersion version) {
        super(LanguageObject.class, parentNode, dataTypeManager, version);
    }

    @Override
    public void visitObject(LanguageObject obj) {
        if (obj == null) {
            return;
        }
        obj.acceptVisitor((LanguageVisitor)this.nodeVisitor);
    }

    private class NodeVisitor
    extends LanguageVisitor {
        private NodeVisitor() {
        }

        private void visitCacheHint(Node parent, CacheHint hint) throws Exception {
            if (hint == null) {
                return;
            }
            AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(parent, "tsql:cacheHint");
            Node cHintNode = NodeGenerator.this.create(hint);
            CacheDirective.Invalidation invalidation = hint.getInvalidation();
            if (invalidation != null) {
                NodeGenerator.this.setProperty(cHintNode, "tsql:invalidation", invalidation.name());
            }
            NodeGenerator.this.setProperty(cHintNode, "tsql:minRows", hint.getMinRows());
            NodeGenerator.this.setProperty(cHintNode, "tsql:prefersMemory", hint.getPrefersMemory());
            NodeGenerator.this.setProperty(cHintNode, "tsql:readAll", hint.getReadAll());
            CacheDirective.Scope scope = hint.getScope();
            if (scope != null) {
                NodeGenerator.this.setProperty(cHintNode, "tsql:scope", scope.name());
            }
            NodeGenerator.this.setProperty(cHintNode, "tsql:ttl", hint.getTtl());
            NodeGenerator.this.setProperty(cHintNode, "tsql:updateable", hint.getUpdatable());
            context.reset();
        }

        private void visitSubqueryHint(Node parent, ExistsCriteria.SubqueryHint hint) throws Exception {
            if (hint == null) {
                return;
            }
            AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(parent, "tsql:subqueryHint");
            Node sqHintNode = NodeGenerator.this.create(hint);
            NodeGenerator.this.setProperty(sqHintNode, "tsql:mergeJoin", hint.isMergeJoin());
            NodeGenerator.this.setProperty(sqHintNode, "tsql:noUnnest", hint.isNoUnnest());
            NodeGenerator.this.setProperty(sqHintNode, "tsql:depJoin", hint.isDepJoin());
            context.reset();
        }

        private void visitSpecificHint(Node parent, SourceHint.SpecificHint hint) throws Exception {
            if (hint == null) {
                return;
            }
            AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(parent, "tsql:sourceHints");
            Node spHintNode = NodeGenerator.this.create(hint);
            NodeGenerator.this.setProperty(spHintNode, "tsql:hint", hint.getHint());
            NodeGenerator.this.setProperty(spHintNode, "tsql:useAliases", hint.isUseAliases());
            context.reset();
        }

        private void visitSourceHint(Node parent, SourceHint hint) throws Exception {
            if (hint == null) {
                return;
            }
            AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(parent, "tsql:sourceHint");
            Node srcHintNode = NodeGenerator.this.create(hint);
            NodeGenerator.this.setProperty(srcHintNode, "tsql:generalHint", hint.getGeneralHint());
            for (Map.Entry entry : hint.getSpecificHints().entrySet()) {
                this.visitSpecificHint(srcHintNode, (SourceHint.SpecificHint)entry.getValue());
            }
            context.reset();
        }

        private void visitFromClause(Node node, FromClause obj) throws Exception {
            NodeGenerator.this.setProperty(node, "tsql:optional", obj.isOptional());
            NodeGenerator.this.setProperty(node, "tsql:makeInd", obj.getMakeInd());
            NodeGenerator.this.setProperty(node, "tsql:noUnnest", obj.isNoUnnest());
            NodeGenerator.this.setProperty(node, "tsql:makeNotDep", obj.isMakeNotDep());
            NodeGenerator.this.setProperty(node, "tsql:preserve", obj.isPreserve());
            Option.MakeDep makeDep = obj.getMakeDep();
            if (makeDep != null) {
                AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(node, "tsql:makeDependency");
                Node makeDepNode = NodeGenerator.this.create(makeDep);
                NodeGenerator.this.setProperty(makeDepNode, "tsql:max", makeDep.getMax());
                NodeGenerator.this.setProperty(makeDepNode, "tsql:join", makeDep.getJoin());
                context.reset();
            }
        }

        private void visitSPParameter(Node parent, String reference, SPParameter obj) throws Exception {
            AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(parent, reference);
            Node node = NodeGenerator.this.create(obj);
            String name = obj.getName();
            if (name != null && name.length() > 0) {
                NodeGenerator.this.setProperty(node, "tsql:name", name);
            }
            NodeGenerator.this.setProperty(node, "tsql:parameterType", obj.getParameterType());
            Class classType = obj.getClassType();
            if (classType != null) {
                NodeGenerator.this.setProperty(node, "tsql:classTypeClass", classType.getCanonicalName());
            }
            NodeGenerator.this.setProperty(node, "tsql:index", obj.getIndex());
            NodeGenerator.this.setProperty(node, "tsql:metadataiD", obj.getMetadataID());
            NodeGenerator.this.setProperty(node, "tsql:usingDefault", obj.isUsingDefault());
            NodeGenerator.this.setProperty(node, "tsql:varArg", obj.isVarArg());
            NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
            NodeGenerator.this.visitObjects(node, "tsql:resultSetColumn", obj.getResultSetColumns());
            context.reset();
        }

        public void visit(BetweenCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:negated", obj.isNegated());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
                NodeGenerator.this.visitObject(node, "tsql:lowerExpression", obj.getLowerExpression());
                NodeGenerator.this.visitObject(node, "tsql:upperExpression", obj.getUpperExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(CaseExpression obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                DataTypeManager.DataTypeName dataTypeName = NodeGenerator.this.getDataTypeManager().retrieveDataTypeName(obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:typeClass", dataTypeName.name());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
                NodeGenerator.this.visitObjects(node, "tsql:when", obj.getWhen());
                NodeGenerator.this.visitObjects(node, "tsql:then", obj.getThen());
                NodeGenerator.this.visitObject(node, "tsql:elseExpression", obj.getElseExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(CompareCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:optional", obj.isOptional());
                CriteriaOperator.Operator operator = CriteriaOperator.Operator.findOperator((int)obj.getOperator());
                if (operator != null) {
                    NodeGenerator.this.setProperty(node, "tsql:operator", operator.name());
                }
                NodeGenerator.this.visitObject(node, "tsql:rightExpression", obj.getRightExpression());
                NodeGenerator.this.visitObject(node, "tsql:leftExpression", obj.getLeftExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(CompoundCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:operator", obj.getOperator());
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObjects(node, "tsql:criteria", obj.getCriteria());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        private void visitCommand(Node node, Command obj) throws Exception {
            this.visitCacheHint(node, obj.getCacheHint());
            this.visitSourceHint(node, obj.getSourceHint());
            NodeGenerator.this.setProperty(node, "tsql:type", obj.getType());
            NodeGenerator.this.setProperty(node, "tsql:isResolved", obj.isResolved());
            NodeGenerator.this.visitObject(node, "tsql:option", obj.getOption());
        }

        public void visit(Delete obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
                NodeGenerator.this.visitObject(node, "tsql:group", obj.getGroup());
                NodeGenerator.this.visitObject(node, "tsql:criteria", obj.getCriteria());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(ExistsCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                DataTypeManager.DataTypeName dataTypeName = NodeGenerator.this.getDataTypeManager().retrieveDataTypeName(obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:typeClass", dataTypeName.name());
                NodeGenerator.this.setProperty(node, "tsql:negated", obj.isNegated());
                NodeGenerator.this.visitObject(node, "tsql:command", obj.getCommand());
                this.visitSubqueryHint(node, obj.getSubqueryHint());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(From obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.visitObjects(node, "tsql:clauses", obj.getClauses());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(GroupBy obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:rollup", obj.isRollup());
                NodeGenerator.this.visitObjects(node, "tsql:symbols", obj.getSymbols());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Insert obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
                NodeGenerator.this.visitObject(node, "tsql:group", obj.getGroup());
                NodeGenerator.this.visitObjects(node, "tsql:variables", obj.getVariables());
                NodeGenerator.this.visitObjects(node, "tsql:values", obj.getValues());
                NodeGenerator.this.visitObject(node, "tsql:queryExpression", obj.getQueryExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(IsNullCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:negated", obj.isNegated());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(JoinPredicate obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.visitObject(node, "tsql:leftClause", obj.getLeftClause());
                NodeGenerator.this.visitObject(node, "tsql:rightClause", obj.getRightClause());
                NodeGenerator.this.visitObject(node, "tsql:joinType", obj.getJoinType());
                NodeGenerator.this.visitObjects(node, "tsql:joinCriteria", obj.getJoinCriteria());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(JoinType obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                JoinTypeTypes joinType = JoinTypeTypes.findType((int)obj.hashCode());
                if (joinType != null) {
                    NodeGenerator.this.setProperty(node, "tsql:kind", joinType.name());
                }
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Limit obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:strict", obj.isStrict());
                NodeGenerator.this.setProperty(node, "tsql:implicit", obj.isImplicit());
                NodeGenerator.this.visitObject(node, "tsql:offset", obj.getOffset());
                NodeGenerator.this.visitObject(node, "tsql:rowLimit", obj.getRowLimit());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(MatchCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:escapeChar", Character.valueOf(obj.getEscapeChar()));
                NodeGenerator.this.setProperty(node, "tsql:negated", obj.isNegated());
                Like.MatchMode mode = obj.getMode();
                if (mode != null) {
                    NodeGenerator.this.setProperty(node, "tsql:mode", mode);
                }
                NodeGenerator.this.visitObject(node, "tsql:leftExpression", obj.getLeftExpression());
                NodeGenerator.this.visitObject(node, "tsql:rightExpression", obj.getRightExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(NotCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObject(node, "tsql:criteria", obj.getCriteria());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Option obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:noCache", obj.isNoCache());
                NodeGenerator.this.setProperty(node, "tsql:noCacheGroups", obj.getNoCacheGroups());
                NodeGenerator.this.setProperty(node, "tsql:notDependentGroups", obj.getNotDependentGroups());
                List makeDeps = obj.getMakeDepOptions();
                if (makeDeps != null) {
                    AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(node, "tsql:dependentGroupOptions");
                    for (Option.MakeDep makeDep : makeDeps) {
                        Node makeDepNode = NodeGenerator.this.create(makeDep);
                        NodeGenerator.this.setProperty(makeDepNode, "tsql:join", makeDep.getJoin());
                        NodeGenerator.this.setProperty(makeDepNode, "tsql:max", makeDep.getMax());
                    }
                    context.reset();
                }
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(OrderBy obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.visitObjects(node, "tsql:orderByItems", obj.getOrderByItems());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Query obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
                NodeGenerator.this.visitObjects(node, "tsql:with", obj.getWith());
                NodeGenerator.this.visitObject(node, "tsql:select", obj.getSelect());
                NodeGenerator.this.visitObject(node, "tsql:into", obj.getInto());
                NodeGenerator.this.visitObject(node, "tsql:from", obj.getFrom());
                NodeGenerator.this.visitObject(node, "tsql:criteria", obj.getCriteria());
                NodeGenerator.this.visitObject(node, "tsql:groupBy", obj.getGroupBy());
                NodeGenerator.this.visitObject(node, "tsql:having", obj.getHaving());
                NodeGenerator.this.visitObject(node, "tsql:orderBy", obj.getOrderBy());
                NodeGenerator.this.visitObject(node, "tsql:limit", obj.getLimit());
                NodeGenerator.this.visitObject(node, "tsql:option", obj.getOption());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(SearchedCaseExpression obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObjects(node, "tsql:when", obj.getWhen());
                NodeGenerator.this.visitObjects(node, "tsql:then", obj.getThen());
                NodeGenerator.this.visitObject(node, "tsql:elseExpression", obj.getElseExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Select obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:distinct", obj.isDistinct());
                NodeGenerator.this.visitObjects(node, "tsql:symbols", obj.getSymbols());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(SetCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:negated", obj.isNegated());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
                NodeGenerator.this.visitObjects(node, "tsql:values", obj.getValues());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(SetQuery obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
                NodeGenerator.this.setProperty(node, "tsql:all", obj.isAll());
                SetQuery.Operation operation = obj.getOperation();
                if (operation != null) {
                    NodeGenerator.this.setProperty(node, "tsql:operation", operation.name());
                }
                NodeGenerator.this.visitObject(node, "tsql:leftQuery", obj.getLeftQuery());
                NodeGenerator.this.visitObject(node, "tsql:rightQuery", obj.getRightQuery());
                NodeGenerator.this.visitObject(node, "tsql:orderBy", obj.getOrderBy());
                NodeGenerator.this.visitObject(node, "tsql:limit", obj.getLimit());
                NodeGenerator.this.visitObjects(node, "tsql:with", obj.getWith());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(StoredProcedure obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
                NodeGenerator.this.setProperty(node, "tsql:calledWithReturn", obj.isCalledWithReturn());
                NodeGenerator.this.setProperty(node, "tsql:callableStatement", obj.isCallableStatement());
                NodeGenerator.this.setProperty(node, "tsql:displayNamedParameters", obj.displayNamedParameters());
                NodeGenerator.this.setProperty(node, "tsql:procedureiD", obj.getProcedureID());
                NodeGenerator.this.setProperty(node, "tsql:procedureName", obj.getProcedureName());
                NodeGenerator.this.visitObject(node, "tsql:group", obj.getGroup());
                for (SPParameter parameter : obj.getParameters()) {
                    this.visitSPParameter(node, "tsql:parameters", parameter);
                }
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(SubqueryCompareCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:operator", obj.getOperatorAsString());
                NodeGenerator.this.setProperty(node, "tsql:predicateQuantifier", obj.getPredicateQuantifierAsString());
                NodeGenerator.this.visitObject(node, "tsql:command", obj.getCommand());
                NodeGenerator.this.visitObject(node, "tsql:leftExpression", obj.getLeftExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(SubqueryFromClause obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                Method getter = null;
                try {
                    getter = obj.getClass().getMethod("isLateral", new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    getter = obj.getClass().getMethod("isTable", new Class[0]);
                }
                NodeGenerator.this.setProperty(node, "tsql:table", getter.invoke((Object)obj, new Object[0]));
                this.visitFromClause(node, (FromClause)obj);
                NodeGenerator.this.visitObject(node, "tsql:command", obj.getCommand());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(SubquerySetCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitSubqueryHint(node, obj.getSubqueryHint());
                NodeGenerator.this.setProperty(node, "tsql:negated", obj.isNegated());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
                NodeGenerator.this.visitObject(node, "tsql:command", obj.getCommand());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(UnaryFromClause obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitFromClause(node, (FromClause)obj);
                NodeGenerator.this.visitObject(node, "tsql:group", obj.getGroup());
                NodeGenerator.this.visitObject(node, "tsql:expandedCommand", obj.getExpandedCommand());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Update obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
                NodeGenerator.this.visitObject(node, "tsql:changeList", obj.getChangeList());
                NodeGenerator.this.visitObject(node, "tsql:group", obj.getGroup());
                NodeGenerator.this.visitObject(node, "tsql:criteria", obj.getCriteria());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Into obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.visitObject(node, "tsql:group", obj.getGroup());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(AggregateSymbol obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                NodeGenerator.this.setProperty(node, "tsql:implicit", obj.isImplicit());
                NodeGenerator.this.setProperty(node, "tsql:distinct", obj.isDistinct());
                NodeGenerator.this.setProperty(node, "tsql:windowed", obj.isWindowed());
                DataTypeManager.DataTypeName dataType = NodeGenerator.this.getDataTypeManager().retrieveDataTypeName(obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:typeClass", dataType.name());
                AggregateSymbol.Type funcType = obj.getAggregateFunction();
                if (funcType == null) {
                    funcType = AggregateSymbol.Type.USER_DEFINED;
                }
                NodeGenerator.this.setProperty(node, "tsql:aggregateFunction", funcType.name());
                Expression[] args = obj.getArgs();
                if (args != null) {
                    AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(node, "tsql:args");
                    for (Expression expr : args) {
                        NodeGenerator.this.visitObject((LanguageObject)expr);
                    }
                    context.reset();
                }
                NodeGenerator.this.visitObject(node, "tsql:condition", obj.getCondition());
                NodeGenerator.this.visitObject(node, "tsql:args", obj.getOrderBy());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(AliasSymbol obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                NodeGenerator.this.setProperty(node, "tsql:shortName", obj.getShortName());
                NodeGenerator.this.setProperty(node, "tsql:outputName", obj.getOutputName());
                NodeGenerator.this.visitObject(node, "tsql:symbol", obj.getSymbol());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(MultipleElementSymbol obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObject(node, "tsql:group", obj.getGroup());
                NodeGenerator.this.visitObjects(node, "tsql:elementSymbols", obj.getElementSymbols());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Constant obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:multiValued", obj.isMultiValued());
                NodeGenerator.this.setProperty(node, "tsql:value", obj.getValue());
                DataTypeManager.DataTypeName dataTypeName = NodeGenerator.this.getDataTypeManager().retrieveDataTypeName(obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:typeClass", dataTypeName.name());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(ElementSymbol obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                NodeGenerator.this.setProperty(node, "tsql:shortName", obj.getShortName());
                NodeGenerator.this.setProperty(node, "tsql:outputName", obj.getOutputName());
                NodeGenerator.this.setProperty(node, "tsql:metadataiD", obj.getMetadataID());
                NodeGenerator.this.setProperty(node, "tsql:externalReference", obj.isExternalReference());
                ElementSymbol.DisplayMode displayMode = obj.getDisplayMode();
                NodeGenerator.this.setProperty(node, "tsql:displayMode", displayMode.name());
                NodeGenerator.this.setProperty(node, "tsql:displayFullyQualified", ElementSymbol.DisplayMode.FULLY_QUALIFIED.equals((Object)displayMode));
                NodeGenerator.this.visitObject(node, "tsql:groupSymbol", obj.getGroupSymbol());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(ExpressionSymbol obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                NodeGenerator.this.setProperty(node, "tsql:shortName", obj.getShortName());
                NodeGenerator.this.setProperty(node, "tsql:outputName", obj.getOutputName());
                Expression expression = obj.getExpression();
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", expression.getType());
                NodeGenerator.this.visitObject(node, "tsql:expression", expression);
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Function obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                NodeGenerator.this.setProperty(node, "tsql:implicit", obj.isImplicit());
                NodeGenerator.this.visitObjects(node, "tsql:args", obj.getArgs());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(GroupSymbol obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                NodeGenerator.this.setProperty(node, "tsql:shortName", obj.getShortName());
                NodeGenerator.this.setProperty(node, "tsql:outputName", obj.getOutputName());
                NodeGenerator.this.setProperty(node, "tsql:procedure", obj.isProcedure());
                NodeGenerator.this.setProperty(node, "tsql:metadataiD", obj.getMetadataID());
                NodeGenerator.this.setProperty(node, "tsql:definition", obj.getOutputDefinition());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Reference obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:positional", obj.isPositional());
                NodeGenerator.this.setProperty(node, "tsql:index", obj.getIndex());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(ScalarSubquery obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObject(node, "tsql:command", obj.getCommand());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        private void visitAssignmentStatement(Node node, AssignmentStatement obj) throws Exception {
            NodeGenerator.this.setStatementTypeProperty(node, obj.getType());
            NodeGenerator.this.setDataTypeProperty(node, "tsql:expectedTypeClass", obj.getExpectedType());
            NodeGenerator.this.visitObject(node, "tsql:variable", obj.getVariable());
            NodeGenerator.this.visitObject(node, "tsql:command", obj.getCommand());
            NodeGenerator.this.visitObject(node, "tsql:value", (Expression)obj.getExpression().clone());
        }

        public void visit(AssignmentStatement obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitAssignmentStatement(node, obj);
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(Block obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setStatementTypeProperty(node, obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:atomic", obj.isAtomic());
                NodeGenerator.this.setProperty(node, "tsql:exceptionGroup", obj.getExceptionGroup());
                NodeGenerator.this.setProperty(node, "tsql:label", obj.getLabel());
                NodeGenerator.this.visitObjects(node, "tsql:statements", obj.getStatements());
                NodeGenerator.this.visitObjects(node, "tsql:exceptionStatements", obj.getExceptionStatements());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(CommandStatement obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setStatementTypeProperty(node, obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:returnable", obj.isReturnable());
                NodeGenerator.this.visitObject(node, "tsql:command", obj.getCommand());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(CreateProcedureCommand obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
                NodeGenerator.this.visitObject(node, "tsql:block", obj.getBlock());
                NodeGenerator.this.visitObject(node, "tsql:virtualGroup", obj.getVirtualGroup());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(DeclareStatement obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setStatementTypeProperty(node, obj.getType());
                NodeGenerator.this.setDataTypeProperty(node, "tsql:expectedTypeClass", obj.getExpectedType());
                NodeGenerator.this.setProperty(node, "tsql:variableType", obj.getVariableType());
                NodeGenerator.this.visitObject(node, "tsql:variable", obj.getVariable());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
                NodeGenerator.this.visitObject(node, "tsql:command", obj.getCommand());
                if (obj.getExpression() != null) {
                    NodeGenerator.this.visitObject(node, "tsql:value", (Expression)obj.getExpression().clone());
                }
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(IfStatement obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setStatementTypeProperty(node, obj.getType());
                NodeGenerator.this.visitObject(node, "tsql:condition", obj.getCondition());
                NodeGenerator.this.visitObject(node, "tsql:ifBlock", obj.getIfBlock());
                NodeGenerator.this.visitObject(node, "tsql:elseBlock", obj.getElseBlock());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(RaiseStatement obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setStatementTypeProperty(node, obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:warning", obj.isWarning());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(BranchingStatement obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setStatementTypeProperty(node, obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:label", obj.getLabel());
                NodeGenerator.this.setProperty(node, "tsql:mode", obj.getMode().name());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(WhileStatement obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setStatementTypeProperty(node, obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:label", obj.getLabel());
                NodeGenerator.this.visitObject(node, "tsql:condition", obj.getCondition());
                NodeGenerator.this.visitObject(node, "tsql:block", obj.getBlock());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(LoopStatement obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setStatementTypeProperty(node, obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:label", obj.getLabel());
                NodeGenerator.this.setProperty(node, "tsql:cursorName", obj.getCursorName());
                NodeGenerator.this.visitObject(node, "tsql:command", obj.getCommand());
                NodeGenerator.this.visitObject(node, "tsql:block", obj.getBlock());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(DynamicCommand obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
                NodeGenerator.this.setProperty(node, "tsql:asClauseSet", obj.isAsClauseSet());
                NodeGenerator.this.setProperty(node, "tsql:updatingModelCount", obj.getUpdatingModelCount());
                NodeGenerator.this.visitObject(node, "tsql:intoGroup", obj.getIntoGroup());
                NodeGenerator.this.visitObject(node, "tsql:sql", obj.getSql());
                NodeGenerator.this.visitObject(node, "tsql:using", obj.getUsing());
                NodeGenerator.this.visitObjects(node, "tsql:asColumns", obj.getAsColumns());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(SetClauseList obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.visitObjects(node, "tsql:setClauses", obj.getClauses());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(SetClause obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.visitObject(node, "tsql:symbol", obj.getSymbol());
                NodeGenerator.this.visitObject(node, "tsql:value", obj.getValue());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(OrderByItem obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:ascending", obj.isAscending());
                SortSpecification.NullOrdering nullOrdering = obj.getNullOrdering();
                if (nullOrdering != null) {
                    NodeGenerator.this.setProperty(node, "tsql:nullOrdering", nullOrdering.name());
                }
                NodeGenerator.this.visitObject(node, "tsql:symbol", obj.getSymbol());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(XMLElement obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:typeClass", DataTypeManager.DataTypeName.XML.name());
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                NodeGenerator.this.visitObject(node, "tsql:namespaces", obj.getNamespaces());
                NodeGenerator.this.visitObject(node, "tsql:attributes", obj.getAttributes());
                NodeGenerator.this.visitObjects(node, "tsql:content", obj.getContent());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(XMLAttributes obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.visitObjects(node, "tsql:args", obj.getArgs());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(XMLForest obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObjects(node, "tsql:arguments", obj.getArgs());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(XMLNamespaces obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(node, "tsql:namespaceItems");
                for (XMLNamespaces.NamespaceItem item : obj.getNamespaceItems()) {
                    Node itemNode = NodeGenerator.this.create(item);
                    NodeGenerator.this.setProperty(itemNode, "tsql:uri", item.getUri());
                    NodeGenerator.this.setProperty(itemNode, "tsql:prefix", item.getPrefix());
                }
                context.reset();
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(TextTable obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                NodeGenerator.this.setProperty(node, "tsql:delimiter", obj.getDelimiter());
                NodeGenerator.this.setProperty(node, "tsql:escape", obj.isEscape());
                NodeGenerator.this.setProperty(node, "tsql:header", obj.getHeader());
                NodeGenerator.this.setProperty(node, "tsql:skip", obj.getSkip());
                NodeGenerator.this.setProperty(node, "tsql:quote", obj.getQuote());
                NodeGenerator.this.setProperty(node, "tsql:usingRowDelimiter", obj.isUsingRowDelimiter());
                NodeGenerator.this.setProperty(node, "tsql:selector", obj.getSelector());
                NodeGenerator.this.setProperty(node, "tsql:fixedWidth", obj.isFixedWidth());
                this.visitFromClause(node, (FromClause)obj);
                NodeGenerator.this.visitObject(node, "tsql:file", obj.getFile());
                AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(node, "tsql:columns");
                for (TextTable.TextColumn column : obj.getColumns()) {
                    Node columnNode = NodeGenerator.this.create(column);
                    NodeGenerator.this.setProperty(columnNode, "tsql:name", column.getName());
                    NodeGenerator.this.setProperty(columnNode, "tsql:type", column.getType());
                    NodeGenerator.this.setProperty(columnNode, "tsql:ordinal", column.isOrdinal());
                    NodeGenerator.this.setProperty(columnNode, "tsql:noTrim", column.isNoTrim());
                    NodeGenerator.this.setProperty(columnNode, "tsql:selector", column.getSelector());
                    NodeGenerator.this.setProperty(columnNode, "tsql:position", column.getPosition());
                    NodeGenerator.this.setProperty(columnNode, "tsql:width", column.getWidth());
                    NodeGenerator.this.setProperty(columnNode, "tsql:header", column.getHeader());
                }
                context.reset();
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(TextLine obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:delimiter", obj.getDelimiter());
                NodeGenerator.this.setProperty(node, "tsql:quote", obj.getQuote());
                NodeGenerator.this.setProperty(node, "tsql:includeHeader", obj.isIncludeHeader());
                NodeGenerator.this.setProperty(node, "tsql:encoding", obj.getEncoding());
                NodeGenerator.this.visitObjects(node, "tsql:expressions", obj.getExpressions());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(XMLTable obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                NodeGenerator.this.setProperty(node, "tsql:xquery", obj.getXquery());
                NodeGenerator.this.setProperty(node, "tsql:usingDefaultColumn", obj.isUsingDefaultColumn());
                this.visitFromClause(node, (FromClause)obj);
                NodeGenerator.this.visitObject(node, "tsql:namespaces", obj.getNamespaces());
                NodeGenerator.this.visitObjects(node, "tsql:passing", obj.getPassing());
                AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(node, "tsql:columns");
                for (XMLTable.XMLColumn column : obj.getColumns()) {
                    Node columnNode = NodeGenerator.this.create(column);
                    NodeGenerator.this.setProperty(columnNode, "tsql:name", column.getName());
                    NodeGenerator.this.setProperty(columnNode, "tsql:type", column.getType());
                    NodeGenerator.this.setProperty(columnNode, "tsql:ordinal", column.getPath());
                    NodeGenerator.this.setProperty(columnNode, "tsql:path", column.getPath());
                    NodeGenerator.this.visitObject(columnNode, "tsql:defaultExpression", column.getDefaultExpression());
                }
                context.reset();
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(DerivedColumn obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:alias", obj.getAlias());
                NodeGenerator.this.setProperty(node, "tsql:propagateName", obj.isPropagateName());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(XMLSerialize obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:encoding", obj.getEncoding());
                NodeGenerator.this.setProperty(node, "tsql:version", obj.getVersion());
                NodeGenerator.this.setProperty(node, "tsql:declaration", obj.getDeclaration());
                NodeGenerator.this.setProperty(node, "tsql:document", obj.getDocument());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(XMLQuery obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:xquery", obj.getXquery());
                NodeGenerator.this.setProperty(node, "tsql:emptyOnEmpty", obj.getEmptyOnEmpty());
                NodeGenerator.this.visitObject(node, "tsql:namespaces", obj.getNamespaces());
                NodeGenerator.this.visitObjects(node, "tsql:passing", obj.getPassing());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(QueryString obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObject(node, "tsql:path", obj.getPath());
                NodeGenerator.this.visitObjects(node, "tsql:args", obj.getArgs());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(XMLParse obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.setProperty(node, "tsql:document", obj.isDocument());
                NodeGenerator.this.setProperty(node, "tsql:wellFormed", obj.isWellFormed());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(ExpressionCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(WithQueryCommand obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.visitObject(node, "tsql:groupSymbol", obj.getGroupSymbol());
                NodeGenerator.this.visitObject(node, "tsql:queryExpression", obj.getCommand());
                NodeGenerator.this.visitObject(node, "tsql:command", (Command)obj.getCommand().clone());
                NodeGenerator.this.visitObjects(node, "tsql:columns", obj.getColumns());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(TriggerAction obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
                NodeGenerator.this.visitObject(node, "tsql:block", obj.getBlock());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(ArrayTable obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                this.visitFromClause(node, (FromClause)obj);
                NodeGenerator.this.visitObject(node, "tsql:arrayValue", obj.getArrayValue());
                AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(node, "tsql:columns");
                for (TableFunctionReference.ProjectedColumn column : obj.getColumns()) {
                    Node columnNode = NodeGenerator.this.create(column);
                    NodeGenerator.this.setProperty(columnNode, "tsql:name", column.getName());
                    NodeGenerator.this.setProperty(columnNode, "tsql:type", column.getType());
                }
                context.reset();
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(AlterView obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(AlterProcedure obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(AlterTrigger obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitCommand(node, (Command)obj);
                NodeGenerator.this.setProperty(node, "tsql:event", obj.getEvent().name());
                NodeGenerator.this.setProperty(node, "tsql:create", obj.isCreate());
                NodeGenerator.this.setProperty(node, "tsql:enabled", obj.getEnabled());
                NodeGenerator.this.visitObject(node, "tsql:target", obj.getTarget());
                NodeGenerator.this.visitObject(node, "tsql:definition", obj.getDefinition());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(WindowFunction obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObject(node, "tsql:function", obj.getFunction());
                NodeGenerator.this.visitObject(node, "tsql:windowSpecification", obj.getWindowSpecification());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(WindowSpecification obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.visitObject(node, "tsql:orderBy", obj.getOrderBy());
                NodeGenerator.this.visitObjects(node, "tsql:partition", obj.getPartition());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(ObjectTable obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitFromClause(node, (FromClause)obj);
                NodeGenerator.this.setProperty(node, "tsql:name", obj.getName());
                NodeGenerator.this.setProperty(node, "tsql:rowScript", obj.getRowScript());
                NodeGenerator.this.setProperty(node, "tsql:scriptingLanguage", obj.getScriptingLanguage());
                NodeGenerator.this.visitObjects(node, "tsql:passing", obj.getPassing());
                AbstractNodeGenerator.Context context = NodeGenerator.this.localContext(node, "tsql:columns");
                for (TableFunctionReference.ProjectedColumn column : obj.getColumns()) {
                    Node columnNode = NodeGenerator.this.create(column);
                    NodeGenerator.this.setProperty(columnNode, "tsql:name", column.getName());
                    NodeGenerator.this.setProperty(columnNode, "tsql:type", column.getType());
                }
                context.reset();
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(ExceptionExpression obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObject(node, "tsql:message", obj.getMessage());
                NodeGenerator.this.visitObject(node, "tsql:sqlState", obj.getSqlState());
                NodeGenerator.this.visitObject(node, "tsql:errorCode", obj.getErrorCode());
                NodeGenerator.this.visitObject(node, "tsql:parentExpression", obj.getParent());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(ReturnStatement obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                this.visitAssignmentStatement(node, (AssignmentStatement)obj);
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(JSONObject obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setDataTypeProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObjects(node, "tsql:args", obj.getArgs());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(XMLExists obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObject(node, "tsql:xmlQuery", obj.getXmlQuery());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(XMLCast obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:typeClass", obj.getType());
                NodeGenerator.this.visitObject(node, "tsql:expression", obj.getExpression());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }

        public void visit(IsDistinctCriteria obj) {
            if (NodeGenerator.this.errorOccurred()) {
                return;
            }
            try {
                Node node = NodeGenerator.this.transform(obj);
                NodeGenerator.this.setProperty(node, "tsql:negated", obj.isNegated());
                NodeGenerator.this.visitObject(node, "tsql:leftRowValue", obj.getLeftRowValue());
                NodeGenerator.this.visitObject(node, "tsql:leftRowValue", obj.getRightRowValue());
            }
            catch (Exception ex) {
                NodeGenerator.this.setError(ex);
            }
        }
    }
}

