/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid.impl;

import java.util.Map;
import java.util.Properties;
import org.komodo.spi.runtime.TeiidDataSource;
import org.teiid.core.util.ArgCheck;

public class TeiidDataSourceImpl
implements Comparable<TeiidDataSourceImpl>,
TeiidDataSource {
    private final String name;
    private final Properties properties = new Properties();

    public TeiidDataSourceImpl(String name, Properties properties) {
        ArgCheck.isNotEmpty((String)name, (String)"name");
        ArgCheck.isNotEmpty((Map)properties, (String)"properties");
        this.name = name;
        for (String propName : properties.stringPropertyNames()) {
            this.properties.setProperty(propName, properties.getProperty(propName));
        }
    }

    @Override
    public int compareTo(TeiidDataSourceImpl dataSource) {
        return this.getName().compareTo(dataSource.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TeiidDataSource other = (TeiidDataSource)obj;
        return this.getName().equals(other.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getPropertyValue("display-name");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPropertyValue(String name) {
        return this.properties.getProperty(name);
    }

    public String getType() {
        return this.getPropertyValue("driver-name");
    }

    public String getJndiName() {
        return this.getPropertyValue("jndi-name");
    }

    public String getConnectionUrl() {
        return this.getPropertyValue("connection-url");
    }

    public int hashCode() {
        int result = 0;
        int prime = 31;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Data Source:\t" + this.getName());
        if (!this.getType().equalsIgnoreCase("<unknown>")) {
            sb.append("\nType: \t\t" + this.getType());
        }
        return sb.toString();
    }
}

