/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import org.komodo.spi.outcome.Outcome;
import org.komodo.spi.outcome.OutcomeFactory;
import org.komodo.spi.runtime.ConnectionDriver;
import org.komodo.spi.runtime.ExecutionAdmin;
import org.komodo.spi.runtime.ExecutionConfigurationEvent;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.spi.runtime.TeiidJdbcInfo;
import org.komodo.spi.runtime.TeiidParent;
import org.komodo.spi.runtime.TeiidPropertyDefinition;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.teiid.AbstractConnectionManager;
import org.komodo.teiid.AbstractTeiidInstance;
import org.komodo.teiid.Messages;
import org.komodo.teiid.impl.ConnectionManager;
import org.komodo.teiid.impl.JbossExtensions;
import org.komodo.teiid.impl.TeiidArtifactFactory;
import org.komodo.utils.KLog;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.jdbc.TeiidDriver;

public class TeiidInstanceImpl
extends AbstractTeiidInstance {
    private Admin admin;
    private final TeiidArtifactFactory factory = new TeiidArtifactFactory();
    private final JbossExtensions ext = new JbossExtensions();

    public TeiidInstanceImpl(TeiidParent parent, TeiidVersion teiidVersion, TeiidJdbcInfo jdbcInfo) {
        super(parent, teiidVersion, jdbcInfo);
    }

    @Override
    protected AbstractConnectionManager getConnectionManager() {
        return ConnectionManager.getInstance();
    }

    @Override
    public TeiidVersion getRuntimeVersion() throws Exception {
        return this.ext.getTeiidRuntimeVersion(this.admin);
    }

    @Override
    protected boolean isCoherent() {
        return this.admin != null;
    }

    public boolean isConnected() {
        if (!this.isParentConnected() || !this.isCoherent()) {
            return false;
        }
        return this.ping(ExecutionAdmin.ConnectivityType.ADMIN).isOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws Exception {
        if (!this.isParentConnected()) {
            throw new Exception(Messages.getString(Messages.TeiidInstance.parentNotStartedMessage, this.getHost()));
        }
        Object object = TEIID_INSTANCE_LOCK;
        synchronized (object) {
            if (this.admin == null) {
                try {
                    char[] passwordArray = null;
                    if (this.getTeiidAdminInfo().getPassword() != null) {
                        passwordArray = this.getTeiidAdminInfo().getPassword().toCharArray();
                    }
                    this.getEventManager().permitListeners(false);
                    this.admin = AdminFactory.getInstance().createAdmin(this.getHost(), this.getTeiidAdminInfo().getPort(), this.getTeiidAdminInfo().getUsername(), passwordArray);
                    if (this.admin == null) {
                        throw new Exception("Failed to create a teiid admin connection. Maybe incorrect password?");
                    }
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    this.getEventManager().permitListeners(true);
                }
                this.getEventManager().notifyListeners(ExecutionConfigurationEvent.createTeiidConnectedEvent((TeiidInstance)this));
                this.notifyRefresh();
            }
        }
    }

    public void disconnect() {
        if (this.admin != null) {
            this.admin.close();
            this.admin = null;
        }
        this.notifyRefresh();
    }

    @Override
    protected Outcome pingAdmin() throws Exception {
        this.admin.getSessions();
        return OutcomeFactory.getInstance().createOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Outcome pingJdbc() {
        String host = this.getHost();
        TeiidJdbcInfo teiidJdbcInfo = this.getTeiidJdbcInfo();
        String protocol = "mm://";
        if (teiidJdbcInfo.isSecure()) {
            protocol = "mms://";
        }
        Connection teiidJdbcConnection = null;
        String url = "jdbc:teiid:ping@" + protocol + host + ':' + teiidJdbcInfo.getPort();
        this.admin.deploy("ping-vdb.xml", (InputStream)new ByteArrayInputStream("<vdb name=\"ping\" version=\"1\"><model visible=\"true\" name=\"Foo\" type=\"PHYSICAL\" path=\"/dummy/Foo\"><source name=\"s\" translator-name=\"loopback\"/><metadata type=\"DDL\"><![CDATA[CREATE FOREIGN TABLE G1 (e1 string, e2 integer);]]> </metadata></model></vdb>".getBytes()));
        try {
            String urlAndCredentials = url + ";user=" + teiidJdbcInfo.getUsername() + ";password=" + teiidJdbcInfo.getPassword() + ';';
            TeiidDriver teiidDriver = TeiidDriver.getInstance();
            teiidJdbcConnection = teiidDriver.connect(urlAndCredentials, null);
        }
        catch (SQLException ex) {
            Outcome outcome;
            try {
                String msg = Messages.getString(Messages.ExecutionAdmin.instanceDeployUndeployProblemPingingTeiidJdbc, url);
                outcome = OutcomeFactory.getInstance().createError(msg, (Exception)ex);
            }
            catch (Throwable throwable) {
                try {
                    this.admin.undeploy("ping-vdb.xml");
                    if (teiidJdbcConnection != null) {
                        teiidJdbcConnection.close();
                    }
                    throw throwable;
                }
                catch (Exception ex2) {
                    String msg = Messages.getString(Messages.ExecutionAdmin.instanceDeployUndeployProblemPingingTeiidJdbc, url);
                    return OutcomeFactory.getInstance().createError(msg, ex2);
                }
            }
            this.admin.undeploy("ping-vdb.xml");
            if (teiidJdbcConnection != null) {
                teiidJdbcConnection.close();
            }
            return outcome;
        }
        this.admin.undeploy("ping-vdb.xml");
        if (teiidJdbcConnection != null) {
            teiidJdbcConnection.close();
        }
        return OutcomeFactory.getInstance().createOK();
    }

    public boolean dataSourceExists(String name) throws Exception {
        this.connect();
        return this.admin.getDataSourceNames().contains(name);
    }

    public void deleteDataSource(String dsName) throws Exception {
        this.connect();
        this.admin.deleteDataSource(dsName);
    }

    public TeiidDataSource getDataSource(String name) throws Exception {
        this.connect();
        Properties dataSource = this.admin.getDataSource(name);
        if (dataSource == null) {
            return null;
        }
        return this.factory.createDataSource(name, dataSource);
    }

    @Override
    public Collection<ConnectionDriver> getDataSourceDrivers() throws Exception {
        return this.ext.getDataSourceDrivers(this.admin);
    }

    public Collection<TeiidDataSource> getDataSources() throws Exception {
        this.connect();
        Collection dsNames = this.admin.getDataSourceNames();
        if (dsNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TeiidDataSource> dsSources = new ArrayList<TeiidDataSource>();
        for (String dsName : dsNames) {
            TeiidDataSource dataSource = this.getDataSource(dsName);
            dsSources.add(dataSource);
        }
        return dsSources;
    }

    @Override
    protected void createDataSource(String deploymentName, String templateName, Properties properties) throws Exception {
        this.admin.createDataSource(deploymentName, templateName, properties);
    }

    public Set<String> getDataSourceTypeNames() throws Exception {
        this.connect();
        return this.admin.getDataSourceTemplateNames();
    }

    public TeiidTranslator getTranslator(String name) throws Exception {
        this.connect();
        return this.factory.createTranslator(this.admin.getTranslator(name));
    }

    public Collection<TeiidTranslator> getTranslators() throws Exception {
        this.connect();
        Collection translators = this.admin.getTranslators();
        if (translators.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TeiidTranslator> teiidTranslators = new ArrayList<TeiidTranslator>();
        for (Translator translator : translators) {
            teiidTranslators.add(this.factory.createTranslator(translator));
        }
        return teiidTranslators;
    }

    private boolean isDynamic(VDB vdb) {
        if (vdb == null) {
            return false;
        }
        if (!(vdb instanceof VDBMetaData)) {
            return false;
        }
        return ((VDBMetaData)vdb).isXmlDeployment();
    }

    public Collection<String> getVdbNames() throws Exception {
        this.connect();
        Collection vdbs = this.admin.getVDBs();
        if (vdbs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> teiidVdbNames = new ArrayList<String>();
        for (VDB vdb : vdbs) {
            teiidVdbNames.add(vdb.getName());
        }
        return teiidVdbNames;
    }

    public Collection<TeiidVdb> getVdbs() throws Exception {
        this.connect();
        Collection vdbs = this.admin.getVDBs();
        if (vdbs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TeiidVdb> teiidVdbs = new ArrayList<TeiidVdb>();
        for (VDB vdb : vdbs) {
            if (!this.isDynamic(vdb)) continue;
            teiidVdbs.add(this.factory.createVdb(vdb));
        }
        return teiidVdbs;
    }

    public TeiidVdb getVdb(String name) throws Exception {
        VDB vdb;
        this.connect();
        String methodName = "getVDB";
        if (this.getVersion().isGreaterThan(DefaultTeiidVersion.Version.TEIID_9_0)) {
            Method method = this.admin.getClass().getMethod(methodName, String.class, String.class);
            vdb = (VDB)method.invoke((Object)this.admin, name, "1");
        } else {
            Method method = this.admin.getClass().getMethod(methodName, String.class, Integer.TYPE);
            vdb = (VDB)method.invoke((Object)this.admin, name, 1);
        }
        if (vdb == null) {
            return null;
        }
        if (!this.isDynamic(vdb)) {
            return null;
        }
        return this.factory.createVdb(vdb);
    }

    public String getAdminDriverPath() throws Exception {
        this.connect();
        return Admin.class.getProtectionDomain().getCodeSource().getLocation().getFile();
    }

    public Driver getTeiidDriver(String driverClass) throws Exception {
        this.connect();
        return TeiidDriver.getInstance();
    }

    @Override
    protected void deploy(String name, InputStream stream) throws Exception {
        this.admin.deploy(name, stream);
    }

    @Override
    protected void undeploy(String name) throws Exception {
        this.admin.undeploy(name);
    }

    public String getSchema(String vdbName, String vdbVersion, String modelName) throws Exception {
        int version;
        this.connect();
        String methodName = "getSchema";
        if (this.getVersion().isGreaterThan(DefaultTeiidVersion.Version.TEIID_9_0)) {
            Method method = this.admin.getClass().getMethod(methodName, String.class, String.class, String.class, EnumSet.class, String.class);
            return (String)method.invoke((Object)this.admin, vdbName, vdbVersion, modelName, null, null);
        }
        Method method = this.admin.getClass().getMethod(methodName, String.class, Integer.TYPE, String.class, EnumSet.class, String.class);
        try {
            version = (int)Double.parseDouble(vdbVersion);
        }
        catch (NumberFormatException ex1) {
            try {
                version = Integer.parseInt(vdbVersion);
            }
            catch (Exception ex2) {
                KLog.getLogger().error("Cannot parse vdb version: " + vdbVersion + ". Defaulting to version 1", (Throwable)ex2, new Object[0]);
                version = 1;
            }
        }
        return (String)method.invoke((Object)this.admin, vdbName, version, modelName, null, null);
    }

    public Set<String> getDataSourceTemplateNames() throws Exception {
        this.connect();
        return this.admin.getDataSourceTemplateNames();
    }

    public Collection<TeiidPropertyDefinition> getTemplatePropertyDefns(String templateName) throws Exception {
        this.connect();
        Collection propDefs = this.admin.getTemplatePropertyDefinitions(templateName);
        if (propDefs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TeiidPropertyDefinition> teiidPropDefs = new ArrayList<TeiidPropertyDefinition>();
        for (PropertyDefinition propDef : propDefs) {
            teiidPropDefs.add(this.factory.createPropertyDefinition(propDef));
        }
        return teiidPropDefs;
    }
}

