/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid.impl;

import javax.jcr.Node;
import org.komodo.spi.query.QueryService;
import org.komodo.spi.query.TeiidService;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.spi.runtime.TeiidJdbcInfo;
import org.komodo.spi.runtime.TeiidParent;
import org.komodo.spi.runtime.version.DefaultTeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.type.DataTypeManager;
import org.komodo.teiid.Messages;
import org.komodo.teiid.impl.DataTypeManagerImpl;
import org.komodo.teiid.impl.NodeGenerator;
import org.komodo.teiid.impl.QueryServiceImpl;
import org.komodo.teiid.impl.TeiidInstanceImpl;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;

public class TeiidServiceImpl
implements TeiidService {
    private final TeiidVersion version = new DefaultTeiidVersion(ApplicationInfo.getInstance().getReleaseNumber());
    private DataTypeManager dataTypeManager;

    public TeiidVersion getVersion() {
        return this.version;
    }

    public DataTypeManager getDataTypeManager() {
        if (this.dataTypeManager == null) {
            this.dataTypeManager = new DataTypeManagerImpl(this.getVersion());
        }
        return this.dataTypeManager;
    }

    public void nodeConvert(String sql, Object parent) throws Exception {
        if (!(parent instanceof Node)) {
            throw new Exception(Messages.getString(Messages.TeiidService.NotAJcrNode, new Object[0]));
        }
        if (sql == null) {
            return;
        }
        QueryParser parser = new QueryParser();
        Command command = parser.parseDesignerCommand(sql);
        NodeGenerator generator = new NodeGenerator((Node)parent, this.getDataTypeManager(), this.getVersion());
        generator.visitObject((LanguageObject)command);
        if (generator.errorOccurred()) {
            throw generator.getError();
        }
    }

    public TeiidInstance getTeiidInstance(TeiidParent teiidParent, TeiidJdbcInfo jdbcInfo) throws Exception {
        return new TeiidInstanceImpl(teiidParent, this.getVersion(), jdbcInfo);
    }

    public QueryService getQueryService(String host, int port, String user, String passwd, boolean secure) throws Exception {
        return new QueryServiceImpl(this.getDataTypeManager(), host, port, user, passwd, secure);
    }

    public void dispose() {
    }
}

