/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid.impl;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.teiid.Messages;
import org.teiid.adminapi.Translator;
import org.teiid.core.util.ArgCheck;

public class TeiidTranslatorImpl
implements Comparable<TeiidTranslatorImpl>,
TeiidTranslator {
    private String name;
    private String type;
    private String description;
    private Properties properties = new Properties();

    public TeiidTranslatorImpl(Translator translator) {
        ArgCheck.isNotNull((Object)translator, (String)"translator");
        this.name = translator.getName();
        this.type = translator.getType();
        this.description = translator.getDescription();
        this.setProperties(translator.getProperties());
    }

    @Override
    public int compareTo(TeiidTranslatorImpl translator) {
        ArgCheck.isNotNull((Object)translator, (String)"translator");
        return this.getName().compareTo(translator.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TeiidTranslatorImpl other = (TeiidTranslatorImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public void setProperties(Properties changedProperties) {
        ArgCheck.isNotNull((Object)changedProperties, (String)"changedProperties");
        Set<Map.Entry<Object, Object>> entrySet = changedProperties.entrySet();
        ArgCheck.isNotEmpty(entrySet, (String)"changedProperties");
        for (Map.Entry<Object, Object> entry : entrySet) {
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public String toString() {
        return Messages.getString(Messages.ExecutionAdmin.connectorDetailedName, this.getName(), this.getType());
    }
}

