/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.teiid.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.teiid.Messages;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.util.ArgCheck;

public class TeiidVdbImpl
implements TeiidVdb,
Comparable<TeiidVdbImpl> {
    private static final String PREVIEW = "preview";
    private static final String DEPLOYMENT_NAME = "deployment-name";
    private String name;
    private String version;
    private final boolean isPreview;
    private final String deploymentName;
    private boolean isActive = false;
    private boolean isLoading = false;
    private boolean hasFailed = false;
    private boolean wasRemoved = false;
    private boolean hasModels = false;
    private List<String> errors;
    private Collection<String> modelNames = new ArrayList<String>();
    private Properties properties = new Properties();
    private String vdbExport;

    public TeiidVdbImpl(VDB vdb) throws Exception {
        ArgCheck.isNotNull((Object)vdb, (String)"vdb");
        if (!(vdb instanceof VDBMetaData)) {
            throw new Exception(Messages.getString(Messages.TeiidVdb.onlySupportingDynamicVdbs, new Object[0]));
        }
        VDBMetaData vdbMeta = (VDBMetaData)vdb;
        if (!vdbMeta.isXmlDeployment()) {
            throw new Exception(Messages.getString(Messages.TeiidVdb.onlySupportingDynamicVdbs, new Object[0]));
        }
        this.name = vdb.getName();
        Integer o = vdb.getVersion();
        this.version = ((Object)o).toString();
        this.isPreview = Boolean.parseBoolean(vdb.getProperties().getProperty(PREVIEW));
        this.deploymentName = vdb.getProperties().getProperty(DEPLOYMENT_NAME);
        VDB.Status status = vdb.getStatus();
        this.isActive = VDB.Status.ACTIVE.equals((Object)status);
        this.isLoading = VDB.Status.LOADING.equals((Object)status);
        this.hasFailed = VDB.Status.FAILED.equals((Object)status);
        this.wasRemoved = VDB.Status.REMOVED.equals((Object)status);
        this.hasModels = !vdb.getModels().isEmpty();
        this.errors = vdb.getValidityErrors();
        for (Model model : vdb.getModels()) {
            this.modelNames.add(model.getName());
        }
        for (String name : vdb.getProperties().stringPropertyNames()) {
            this.properties.setProperty(name, vdb.getPropertyValue(name));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        VDBMetadataParser.marshell((VDBMetaData)((VDBMetaData)vdb), (OutputStream)out);
        this.vdbExport = new String(out.toByteArray());
    }

    @Override
    public int compareTo(TeiidVdbImpl vdb) {
        ArgCheck.isNotNull((Object)vdb, (String)"vdb");
        return this.getName().compareTo(vdb.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TeiidVdb other = (TeiidVdb)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDeployedName() {
        return this.deploymentName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isPreviewVdb() {
        return this.isPreview;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public boolean wasRemoved() {
        return this.wasRemoved;
    }

    public List<String> getValidityErrors() {
        if (this.errors != null) {
            return Collections.unmodifiableList(this.errors);
        }
        return Collections.emptyList();
    }

    public boolean hasModels() {
        return this.hasModels;
    }

    public Collection<String> getModelNames() {
        if (!this.hasModels()) {
            return Collections.emptyList();
        }
        return this.modelNames;
    }

    public String getPropertyValue(String key) {
        return this.properties.getProperty(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String export() throws Exception {
        return this.vdbExport;
    }
}

