/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.history;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmark;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.report.WebsiteResourceUtils;

public class BenchmarkHistoryReport {
    protected final DefaultPlannerBenchmark plannerBenchmark;
    protected File benchmarkHistoryDirectory;
    protected Locale locale;
    protected File historyHtmlFile = null;
    protected File summaryDirectory = null;

    public BenchmarkHistoryReport(DefaultPlannerBenchmark plannerBenchmark) {
        this.plannerBenchmark = plannerBenchmark;
    }

    public File getBenchmarkHistoryDirectory() {
        return this.benchmarkHistoryDirectory;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public File getHistoryHtmlFile() {
        return this.historyHtmlFile;
    }

    public File getSummaryDirectory() {
        return this.summaryDirectory;
    }

    public void writeHistory() {
        this.benchmarkHistoryDirectory = new File(this.plannerBenchmark.getBenchmarkDirectory(), "history");
        if (this.benchmarkHistoryDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.benchmarkHistoryDirectory);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can not delete old benchmarkHistoryDirectory (" + this.benchmarkHistoryDirectory + ").", e);
            }
        }
        this.benchmarkHistoryDirectory.mkdir();
        this.summaryDirectory = new File(this.benchmarkHistoryDirectory, "summary");
        this.summaryDirectory.mkdir();
        this.writeHistoryHtmlFile();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeHistoryHtmlFile() {
        WebsiteResourceUtils.copyResourcesTo(this.benchmarkHistoryDirectory);
        this.historyHtmlFile = new File(this.benchmarkHistoryDirectory, "index.html");
        Configuration freemarkerCfg = new Configuration();
        freemarkerCfg.setDefaultEncoding("UTF-8");
        freemarkerCfg.setLocale(this.locale);
        freemarkerCfg.setClassForTemplateLoading(BenchmarkHistoryReport.class, "");
        String templateFilename = "benchmarkHistory.html.ftl";
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("benchmarkHistoryReport", this);
        model.put("reportHelper", new ReportHelper());
        OutputStreamWriter writer = null;
        try {
            Template template = freemarkerCfg.getTemplate(templateFilename);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.historyHtmlFile), "UTF-8");
            template.process(model, (Writer)writer);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Can not read templateFilename (" + templateFilename + ") or write historyHtmlFile (" + this.historyHtmlFile + ").", e);
                catch (TemplateException e2) {
                    throw new IllegalArgumentException("Can not process Freemarker templateFilename (" + templateFilename + ") to historyHtmlFile (" + this.historyHtmlFile + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

