/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.movecountperstep;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.text.NumberFormat;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.optaplanner.benchmark.impl.ProblemBenchmark;
import org.optaplanner.benchmark.impl.SingleBenchmark;
import org.optaplanner.benchmark.impl.statistic.AbstractProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.MillisecondsSpendNumberFormat;
import org.optaplanner.benchmark.impl.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.movecountperstep.MoveCountPerStepMeasurement;
import org.optaplanner.benchmark.impl.statistic.movecountperstep.MoveCountPerStepSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.movecountperstep.MoveCountPerStepSingleStatisticPoint;

public class MoveCountPerStepProblemStatistic
extends AbstractProblemStatistic {
    protected File graphStatisticFile = null;

    public MoveCountPerStepProblemStatistic(ProblemBenchmark problemBenchmark) {
        super(problemBenchmark, ProblemStatisticType.MOVE_COUNT_PER_STEP);
    }

    @Override
    public SingleStatistic createSingleStatistic() {
        return new MoveCountPerStepSingleStatistic();
    }

    public String getGraphFilePath() {
        return this.toFilePath(this.graphStatisticFile);
    }

    @Override
    protected void writeCsvStatistic() {
        AbstractProblemStatistic.ProblemStatisticCsv csv = new AbstractProblemStatistic.ProblemStatisticCsv();
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            if (singleBenchmark.isSuccess()) {
                MoveCountPerStepSingleStatistic singleStatistic = (MoveCountPerStepSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (MoveCountPerStepSingleStatisticPoint point : singleStatistic.getPointList()) {
                    long timeMillisSpend = point.getTimeMillisSpend();
                    MoveCountPerStepMeasurement moveCountPerStepMeasurement = point.getMoveCountPerStepMeasurement();
                    csv.addPoint(singleBenchmark, timeMillisSpend, Long.toString(moveCountPerStepMeasurement.getAcceptedMoveCount()) + "/" + Long.toString(moveCountPerStepMeasurement.getSelectedMoveCount()));
                }
                continue;
            }
            csv.addPoint(singleBenchmark, 0L, "Failed");
        }
        this.csvStatisticFile = new File(this.problemBenchmark.getProblemReportDirectory(), this.problemBenchmark.getName() + "MoveCountPerStepStatistic.csv");
        csv.writeCsvStatisticFile();
    }

    @Override
    protected void writeGraphStatistic() {
        Locale locale = this.problemBenchmark.getPlannerBenchmark().getBenchmarkReport().getLocale();
        NumberAxis xAxis = new NumberAxis("Time spend");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat(locale));
        NumberAxis yAxis = new NumberAxis("Accepted/selected moves per step");
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        DefaultDrawingSupplier drawingSupplier = new DefaultDrawingSupplier();
        plot.setOrientation(PlotOrientation.VERTICAL);
        int seriesIndex = 0;
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            XYSeries acceptedSeries = new XYSeries((Comparable)((Object)(singleBenchmark.getSolverBenchmark().getNameWithFavoriteSuffix() + " accepted")));
            XYSeries selectedSeries = new XYSeries((Comparable)((Object)(singleBenchmark.getSolverBenchmark().getNameWithFavoriteSuffix() + " selected")));
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
            if (singleBenchmark.isSuccess()) {
                MoveCountPerStepSingleStatistic singleStatistic = (MoveCountPerStepSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (MoveCountPerStepSingleStatisticPoint point : singleStatistic.getPointList()) {
                    long timeMillisSpend = point.getTimeMillisSpend();
                    long acceptedMoveCount = point.getMoveCountPerStepMeasurement().getAcceptedMoveCount();
                    long selectedMoveCount = point.getMoveCountPerStepMeasurement().getSelectedMoveCount();
                    acceptedSeries.add((double)timeMillisSpend, (double)acceptedMoveCount);
                    selectedSeries.add((double)timeMillisSpend, (double)selectedMoveCount);
                }
            }
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            seriesCollection.addSeries(acceptedSeries);
            seriesCollection.addSeries(selectedSeries);
            plot.setDataset(seriesIndex, (XYDataset)seriesCollection);
            if (singleBenchmark.getSolverBenchmark().isFavorite()) {
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
                renderer.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
            } else {
                renderer.setSeriesStroke(1, (Stroke)new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
            }
            Paint linePaint = drawingSupplier.getNextPaint();
            renderer.setSeriesPaint(0, linePaint);
            renderer.setSeriesPaint(1, linePaint);
            plot.setRenderer(seriesIndex, (XYItemRenderer)renderer);
            ++seriesIndex;
        }
        JFreeChart chart = new JFreeChart(this.problemBenchmark.getName() + " move count per step statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.graphStatisticFile = this.writeChartToImageFile(chart, this.problemBenchmark.getName() + "MoveCountPerStepStatistic");
    }
}

