/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.api;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.impl.FreemarkerXmlPlannerBenchmarkFactory;
import org.optaplanner.benchmark.impl.XStreamXmlPlannerBenchmarkFactory;

public abstract class PlannerBenchmarkFactory {
    public static PlannerBenchmarkFactory createFromXmlResource(String benchmarkConfigResource) {
        XStreamXmlPlannerBenchmarkFactory plannerBenchmarkFactory = new XStreamXmlPlannerBenchmarkFactory();
        plannerBenchmarkFactory.configure(benchmarkConfigResource);
        return plannerBenchmarkFactory;
    }

    public static PlannerBenchmarkFactory createFromXmlFile(File benchmarkConfigFile) {
        XStreamXmlPlannerBenchmarkFactory plannerBenchmarkFactory = new XStreamXmlPlannerBenchmarkFactory();
        plannerBenchmarkFactory.configure(benchmarkConfigFile);
        return plannerBenchmarkFactory;
    }

    public static PlannerBenchmarkFactory createFromXmlInputStream(InputStream in) {
        XStreamXmlPlannerBenchmarkFactory plannerBenchmarkFactory = new XStreamXmlPlannerBenchmarkFactory();
        plannerBenchmarkFactory.configure(in);
        return plannerBenchmarkFactory;
    }

    public static PlannerBenchmarkFactory createFromXmlReader(Reader reader) {
        XStreamXmlPlannerBenchmarkFactory plannerBenchmarkFactory = new XStreamXmlPlannerBenchmarkFactory();
        plannerBenchmarkFactory.configure(reader);
        return plannerBenchmarkFactory;
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlResource(String templateResource) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlResource(templateResource, null);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlResource(String templateResource, Object model) {
        FreemarkerXmlPlannerBenchmarkFactory plannerBenchmarkFactory = new FreemarkerXmlPlannerBenchmarkFactory();
        plannerBenchmarkFactory.configure(templateResource, model);
        return plannerBenchmarkFactory;
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlFile(File templateFile) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlFile(templateFile, null);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlFile(File templateFile, Object model) {
        FreemarkerXmlPlannerBenchmarkFactory plannerBenchmarkFactory = new FreemarkerXmlPlannerBenchmarkFactory();
        plannerBenchmarkFactory.configure(templateFile, model);
        return plannerBenchmarkFactory;
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlInputStream(InputStream templateIn) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlInputStream(templateIn, null);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlInputStream(InputStream templateIn, Object model) {
        FreemarkerXmlPlannerBenchmarkFactory plannerBenchmarkFactory = new FreemarkerXmlPlannerBenchmarkFactory();
        plannerBenchmarkFactory.configure(templateIn, model);
        return plannerBenchmarkFactory;
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlReader(Reader templateReader) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlReader(templateReader, null);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlReader(Reader templateReader, Object model) {
        FreemarkerXmlPlannerBenchmarkFactory plannerBenchmarkFactory = new FreemarkerXmlPlannerBenchmarkFactory();
        plannerBenchmarkFactory.configure(templateReader, model);
        return plannerBenchmarkFactory;
    }

    public abstract PlannerBenchmarkConfig getPlannerBenchmarkConfig();

    public abstract PlannerBenchmark buildPlannerBenchmark();
}

