/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config.blueprint;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.config.blueprint.SolverBenchmarkBluePrintType;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.solver.SolverConfig;

@XStreamAlias(value="solverBenchmarkBluePrint")
public class SolverBenchmarkBluePrintConfig {
    protected SolverBenchmarkBluePrintType solverBenchmarkBluePrintType = null;

    public SolverBenchmarkBluePrintType getSolverBenchmarkBluePrintType() {
        return this.solverBenchmarkBluePrintType;
    }

    public void setSolverBenchmarkBluePrintType(SolverBenchmarkBluePrintType solverBenchmarkBluePrintType) {
        this.solverBenchmarkBluePrintType = solverBenchmarkBluePrintType;
    }

    public List<SolverBenchmarkConfig> buildSolverBenchmarkConfigList() {
        List<SolverBenchmarkConfig> solverBenchmarkConfigList;
        this.validate();
        switch (this.solverBenchmarkBluePrintType) {
            case ALL_CONSTRUCTION_HEURISTIC_TYPES: {
                solverBenchmarkConfigList = this.buildAllConstructionHeuristicTypes();
                break;
            }
            default: {
                throw new IllegalStateException("The solverBenchmarkBluePrintType (" + (Object)((Object)this.solverBenchmarkBluePrintType) + ") is not implemented.");
            }
        }
        return solverBenchmarkConfigList;
    }

    protected void validate() {
        if (this.solverBenchmarkBluePrintType == null) {
            throw new IllegalArgumentException("The solverBenchmarkBluePrint must have a solverBenchmarkBluePrintType (" + (Object)((Object)this.solverBenchmarkBluePrintType) + ").");
        }
    }

    protected List<SolverBenchmarkConfig> buildAllConstructionHeuristicTypes() {
        ConstructionHeuristicType[] types = ConstructionHeuristicType.values();
        ArrayList<SolverBenchmarkConfig> solverBenchmarkConfigList = new ArrayList<SolverBenchmarkConfig>(types.length);
        for (ConstructionHeuristicType type : types) {
            SolverBenchmarkConfig solverBenchmarkConfig = new SolverBenchmarkConfig();
            solverBenchmarkConfig.setName(type.name());
            SolverConfig solverConfig = new SolverConfig();
            ConstructionHeuristicPhaseConfig phaseConfig = new ConstructionHeuristicPhaseConfig();
            phaseConfig.setConstructionHeuristicType(type);
            solverConfig.setPhaseConfigList(Collections.singletonList(phaseConfig));
            solverBenchmarkConfig.setSolverConfig(solverConfig);
            solverBenchmarkConfigList.add(solverBenchmarkConfig);
        }
        return solverBenchmarkConfigList;
    }
}

