/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.xstream;

import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;
import org.optaplanner.persistence.xstream.impl.score.XStreamBendableScoreConverter;

public class XStreamBendableScoreConverterTest {
    @Test
    public void serializeAndDeserializeWithNullField() {
        XStreamBendableScoreConverterTestObject input = new XStreamBendableScoreConverterTestObject(null);
        PlannerTestUtils.serializeAndDeserializeWithAll((Object)input, (PlannerTestUtils.OutputAsserter)new PlannerTestUtils.OutputAsserter<XStreamBendableScoreConverterTestObject>(){

            public void assertOutput(XStreamBendableScoreConverterTestObject output) {
                Assert.assertEquals(null, (Object)output.getScore());
            }
        });
    }

    @Test
    public void serializeAndDeserialize() {
        XStreamBendableScoreConverterTestObject input = new XStreamBendableScoreConverterTestObject(BendableScore.valueOf((int[])new int[]{-5}, (int[])new int[]{-300, -4000}));
        PlannerTestUtils.serializeAndDeserializeWithAll((Object)input, (PlannerTestUtils.OutputAsserter)new PlannerTestUtils.OutputAsserter<XStreamBendableScoreConverterTestObject>(){

            public void assertOutput(XStreamBendableScoreConverterTestObject output) {
                BendableScore score = output.getScore();
                Assert.assertEquals((long)1L, (long)score.getHardLevelsSize());
                Assert.assertEquals((long)-5L, (long)score.getHardScore(0));
                Assert.assertEquals((long)2L, (long)score.getSoftLevelsSize());
                Assert.assertEquals((long)-300L, (long)score.getSoftScore(0));
                Assert.assertEquals((long)-4000L, (long)score.getSoftScore(1));
            }
        });
    }

    public static class XStreamBendableScoreConverterTestObject
    implements Serializable {
        @XStreamConverter(value=XStreamBendableScoreConverter.class, ints={1, 2})
        private BendableScore score;

        public XStreamBendableScoreConverterTestObject(BendableScore score) {
            this.score = score;
        }

        public BendableScore getScore() {
            return this.score;
        }

        public void setScore(BendableScore score) {
            this.score = score;
        }
    }
}

