/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.xstream;

import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;
import org.optaplanner.persistence.xstream.impl.score.XStreamScoreConverter;

public class XStreamScoreConverterTest {
    @Test
    public void serializeAndDeserializeWithNullField() {
        XStreamScoreConverterTestObject input = new XStreamScoreConverterTestObject(null);
        PlannerTestUtils.serializeAndDeserializeWithAll((Object)input, (PlannerTestUtils.OutputAsserter)new PlannerTestUtils.OutputAsserter<XStreamScoreConverterTestObject>(){

            public void assertOutput(XStreamScoreConverterTestObject output) {
                Assert.assertEquals(null, (Object)output.getScore());
            }
        });
    }

    @Test
    public void serializeAndDeserialize() {
        XStreamScoreConverterTestObject input = new XStreamScoreConverterTestObject(SimpleScore.valueOf((int)123));
        PlannerTestUtils.serializeAndDeserializeWithAll((Object)input, (PlannerTestUtils.OutputAsserter)new PlannerTestUtils.OutputAsserter<XStreamScoreConverterTestObject>(){

            public void assertOutput(XStreamScoreConverterTestObject output) {
                Assert.assertEquals((long)123L, (long)output.getScore().getScore());
            }
        });
    }

    public static class XStreamScoreConverterTestObject
    implements Serializable {
        @XStreamConverter(value=XStreamScoreConverter.class, types={SimpleScoreDefinition.class})
        private SimpleScore score;

        public XStreamScoreConverterTestObject(SimpleScore score) {
            this.score = score;
        }

        public SimpleScore getScore() {
            return this.score;
        }

        public void setScore(SimpleScore score) {
            this.score = score;
        }
    }
}

