/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.calculatecount;

import java.util.List;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemBasedSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.calculatecount.CalculateCountStatisticPoint;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class CalculateCountSubSingleStatistic
extends ProblemBasedSubSingleStatistic<CalculateCountStatisticPoint> {
    private final long timeMillisThresholdInterval;
    private final CalculateCountSubSingleStatisticListener listener;

    public CalculateCountSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        this(subSingleBenchmarkResult, 1000L);
    }

    public CalculateCountSubSingleStatistic(SubSingleBenchmarkResult benchmarkResult, long timeMillisThresholdInterval) {
        super(benchmarkResult, ProblemStatisticType.CALCULATE_COUNT_PER_SECOND);
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
        this.listener = new CalculateCountSubSingleStatisticListener();
    }

    @Override
    public void open(Solver<Solution> solver) {
        ((DefaultSolver)solver).addPhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver<Solution> solver) {
        ((DefaultSolver)solver).removePhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return CalculateCountStatisticPoint.buildCsvLine("timeMillisSpent", "calculateCountPerSecond");
    }

    @Override
    protected CalculateCountStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new CalculateCountStatisticPoint(Long.valueOf(csvLine.get(0)), Long.valueOf(csvLine.get(1)));
    }

    private class CalculateCountSubSingleStatisticListener
    extends PhaseLifecycleListenerAdapter {
        private long nextTimeMillisThreshold;
        private long lastTimeMillisSpent;
        private long lastCalculateCount;

        private CalculateCountSubSingleStatisticListener() {
            this.nextTimeMillisThreshold = CalculateCountSubSingleStatistic.this.timeMillisThresholdInterval;
            this.lastTimeMillisSpent = 0L;
            this.lastCalculateCount = 0L;
        }

        public void stepEnded(AbstractStepScope stepScope) {
            long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpent();
            if (timeMillisSpent >= this.nextTimeMillisThreshold) {
                DefaultSolverScope solverScope = stepScope.getPhaseScope().getSolverScope();
                long calculateCount = solverScope.getCalculateCount();
                long calculateCountInterval = calculateCount - this.lastCalculateCount;
                long timeMillisSpentInterval = timeMillisSpent - this.lastTimeMillisSpent;
                if (timeMillisSpentInterval == 0L) {
                    timeMillisSpentInterval = 1L;
                }
                long averageCalculateCountPerSecond = calculateCountInterval * 1000L / timeMillisSpentInterval;
                CalculateCountSubSingleStatistic.this.pointList.add(new CalculateCountStatisticPoint(timeMillisSpent, averageCalculateCountPerSecond));
                this.lastCalculateCount = calculateCount;
                this.lastTimeMillisSpent = timeMillisSpent;
                this.nextTimeMillisThreshold += CalculateCountSubSingleStatistic.this.timeMillisThresholdInterval;
                if (this.nextTimeMillisThreshold < timeMillisSpent) {
                    this.nextTimeMillisThreshold = timeMillisSpent;
                }
            }
        }
    }
}

