/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.subsingle.constraintmatchtotalbestscore;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.PureSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.common.MillisecondsSpentNumberFormat;
import org.optaplanner.benchmark.impl.statistic.subsingle.constraintmatchtotalbestscore.ConstraintMatchTotalBestScoreStatisticPoint;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.DefaultSolver;

@XStreamAlias(value="constraintMatchTotalBestScoreSubSingleStatistic")
public class ConstraintMatchTotalBestScoreSubSingleStatistic<Solution_>
extends PureSubSingleStatistic<Solution_, ConstraintMatchTotalBestScoreStatisticPoint> {
    @XStreamOmitField
    private ConstraintMatchTotalBestScoreSubSingleStatisticListener listener = new ConstraintMatchTotalBestScoreSubSingleStatisticListener();
    @XStreamOmitField
    protected List<File> graphFileList = null;

    public ConstraintMatchTotalBestScoreSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        super(subSingleBenchmarkResult, SingleStatisticType.CONSTRAINT_MATCH_TOTAL_BEST_SCORE);
    }

    @Override
    public List<File> getGraphFileList() {
        return this.graphFileList;
    }

    @Override
    public void open(Solver<Solution_> solver) {
        DefaultSolver defaultSolver = (DefaultSolver)solver;
        defaultSolver.getSolverScope().getScoreDirector().overwriteConstraintMatchEnabledPreference(true);
        defaultSolver.addPhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver<Solution_> solver) {
        ((DefaultSolver)solver).removePhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return ConstraintMatchTotalBestScoreStatisticPoint.buildCsvLine("timeMillisSpent", "constraintPackage", "constraintName", "scoreLevel", "constraintMatchCount", "weightTotal");
    }

    @Override
    protected ConstraintMatchTotalBestScoreStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new ConstraintMatchTotalBestScoreStatisticPoint(Long.parseLong(csvLine.get(0)), csvLine.get(1), csvLine.get(2), Integer.parseInt(csvLine.get(3)), Integer.parseInt(csvLine.get(4)), Double.parseDouble(csvLine.get(5)));
    }

    @Override
    public void writeGraphFiles(BenchmarkReport benchmarkReport) {
        ArrayList constraintIdToWeightSeriesMapList = new ArrayList(15);
        for (ConstraintMatchTotalBestScoreStatisticPoint point : this.getPointList()) {
            Object constraintId;
            XYSeries weightSeries;
            int scoreLevel = point.getScoreLevel();
            if (scoreLevel >= 15) continue;
            while (scoreLevel >= constraintIdToWeightSeriesMapList.size()) {
                constraintIdToWeightSeriesMapList.add(new LinkedHashMap());
            }
            LinkedHashMap<Object, XYSeries> constraintIdToWeightSeriesMap = (LinkedHashMap<Object, XYSeries>)constraintIdToWeightSeriesMapList.get(scoreLevel);
            if (constraintIdToWeightSeriesMap == null) {
                constraintIdToWeightSeriesMap = new LinkedHashMap<Object, XYSeries>();
                constraintIdToWeightSeriesMapList.set(scoreLevel, constraintIdToWeightSeriesMap);
            }
            if ((weightSeries = (XYSeries)constraintIdToWeightSeriesMap.get(constraintId = point.getConstraintPackage() + ":" + point.getConstraintName())) == null) {
                weightSeries = new XYSeries((Comparable)((Object)(point.getConstraintName() + " weight")));
                constraintIdToWeightSeriesMap.put(constraintId, weightSeries);
            }
            long timeMillisSpent = point.getTimeMillisSpent();
            weightSeries.add((double)timeMillisSpent, point.getWeightTotal());
        }
        this.graphFileList = new ArrayList<File>(constraintIdToWeightSeriesMapList.size());
        for (int scoreLevelIndex = 0; scoreLevelIndex < constraintIdToWeightSeriesMapList.size(); ++scoreLevelIndex) {
            XYPlot plot = this.createPlot(benchmarkReport, scoreLevelIndex);
            XYStepRenderer renderer = new XYStepRenderer();
            plot.setRenderer((XYItemRenderer)renderer);
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            for (XYSeries series : ((Map)constraintIdToWeightSeriesMapList.get(scoreLevelIndex)).values()) {
                seriesCollection.addSeries(series);
            }
            plot.setDataset((XYDataset)seriesCollection);
            String scoreLevelLabel = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().findScoreLevelLabel(scoreLevelIndex);
            JFreeChart chart = new JFreeChart(this.subSingleBenchmarkResult.getName() + " constraint match total best " + scoreLevelLabel + " diff statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.graphFileList.add(this.writeChartToImageFile(chart, "ConstraintMatchTotalBestScoreStatisticLevel" + scoreLevelIndex));
        }
    }

    private XYPlot createPlot(BenchmarkReport benchmarkReport, int scoreLevelIndex) {
        Locale locale = benchmarkReport.getLocale();
        NumberAxis xAxis = new NumberAxis("Time spent");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpentNumberFormat(locale));
        String scoreLevelLabel = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult().findScoreLevelLabel(scoreLevelIndex);
        NumberAxis yAxis = new NumberAxis("Constraint match total " + scoreLevelLabel);
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        yAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }

    private class ConstraintMatchTotalBestScoreSubSingleStatisticListener
    extends PhaseLifecycleListenerAdapter<Solution_> {
        private boolean constraintMatchEnabled;

        private ConstraintMatchTotalBestScoreSubSingleStatisticListener() {
        }

        public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
            InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
            this.constraintMatchEnabled = scoreDirector.isConstraintMatchEnabled();
            if (!this.constraintMatchEnabled) {
                ConstraintMatchTotalBestScoreSubSingleStatistic.this.logger.warn("The subSingleStatistic ({}) cannot function properly because ConstraintMatches are not supported on the ScoreDirector.", (Object)ConstraintMatchTotalBestScoreSubSingleStatistic.this.singleStatisticType);
            }
        }

        public void stepEnded(AbstractStepScope<Solution_> stepScope) {
            if (stepScope instanceof LocalSearchStepScope) {
                this.localSearchStepEnded((LocalSearchStepScope)stepScope);
            }
        }

        private void localSearchStepEnded(LocalSearchStepScope<Solution_> stepScope) {
            if (this.constraintMatchEnabled && stepScope.getBestScoreImproved().booleanValue()) {
                long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow();
                for (ConstraintMatchTotal constraintMatchTotal : stepScope.getScoreDirector().getConstraintMatchTotals()) {
                    ConstraintMatchTotalBestScoreSubSingleStatistic.this.pointList.add(new ConstraintMatchTotalBestScoreStatisticPoint(timeMillisSpent, constraintMatchTotal.getConstraintPackage(), constraintMatchTotal.getConstraintName(), constraintMatchTotal.getScoreLevel(), constraintMatchTotal.getConstraintMatchCount(), constraintMatchTotal.getWeightTotalAsNumber().doubleValue()));
                }
            }
        }

        public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
            if (phaseScope instanceof LocalSearchPhaseScope && this.constraintMatchEnabled && !ConstraintMatchTotalBestScoreSubSingleStatistic.this.pointList.isEmpty()) {
                long timeMillisSpent = phaseScope.calculateSolverTimeMillisSpentUpToNow();
                ConstraintMatchTotalBestScoreStatisticPoint previousPoint = (ConstraintMatchTotalBestScoreStatisticPoint)ConstraintMatchTotalBestScoreSubSingleStatistic.this.pointList.get(ConstraintMatchTotalBestScoreSubSingleStatistic.this.pointList.size() - 1);
                ConstraintMatchTotalBestScoreSubSingleStatistic.this.pointList.add(new ConstraintMatchTotalBestScoreStatisticPoint(timeMillisSpent, previousPoint.getConstraintPackage(), previousPoint.getConstraintName(), previousPoint.getScoreLevel(), previousPoint.getConstraintMatchCount(), previousPoint.getWeightTotal()));
            }
        }
    }
}

