/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.api;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.impl.FreemarkerXmlPlannerBenchmarkFactory;
import org.optaplanner.benchmark.impl.XStreamXmlPlannerBenchmarkFactory;
import org.optaplanner.core.config.SolverConfigContext;

public abstract class PlannerBenchmarkFactory {
    public static PlannerBenchmarkFactory createFromXmlResource(String benchmarkConfigResource) {
        return new XStreamXmlPlannerBenchmarkFactory().configure(benchmarkConfigResource);
    }

    public static PlannerBenchmarkFactory createFromXmlResource(String benchmarkConfigResource, ClassLoader classLoader) {
        return new XStreamXmlPlannerBenchmarkFactory(new SolverConfigContext(classLoader)).configure(benchmarkConfigResource);
    }

    public static PlannerBenchmarkFactory createFromXmlFile(File benchmarkConfigFile) {
        return new XStreamXmlPlannerBenchmarkFactory().configure(benchmarkConfigFile);
    }

    public static PlannerBenchmarkFactory createFromXmlFile(File benchmarkConfigFile, ClassLoader classLoader) {
        return new XStreamXmlPlannerBenchmarkFactory(new SolverConfigContext(classLoader)).configure(benchmarkConfigFile);
    }

    public static PlannerBenchmarkFactory createFromXmlInputStream(InputStream in) {
        return new XStreamXmlPlannerBenchmarkFactory().configure(in);
    }

    public static PlannerBenchmarkFactory createFromXmlInputStream(InputStream in, ClassLoader classLoader) {
        return new XStreamXmlPlannerBenchmarkFactory(new SolverConfigContext(classLoader)).configure(in);
    }

    public static PlannerBenchmarkFactory createFromXmlReader(Reader reader) {
        return new XStreamXmlPlannerBenchmarkFactory().configure(reader);
    }

    public static PlannerBenchmarkFactory createFromXmlReader(Reader reader, ClassLoader classLoader) {
        return new XStreamXmlPlannerBenchmarkFactory(new SolverConfigContext(classLoader)).configure(reader);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlResource(String templateResource) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlResource(templateResource, null);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlResource(String templateResource, ClassLoader classLoader) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlResource(templateResource, null, classLoader);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlResource(String templateResource, Object model) {
        return new FreemarkerXmlPlannerBenchmarkFactory().configure(templateResource, model);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlResource(String templateResource, Object model, ClassLoader classLoader) {
        return new FreemarkerXmlPlannerBenchmarkFactory(new SolverConfigContext(classLoader)).configure(templateResource, model);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlFile(File templateFile) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlFile(templateFile, null);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlFile(File templateFile, ClassLoader classLoader) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlFile(templateFile, null, classLoader);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlFile(File templateFile, Object model) {
        return new FreemarkerXmlPlannerBenchmarkFactory().configure(templateFile, model);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlFile(File templateFile, Object model, ClassLoader classLoader) {
        return new FreemarkerXmlPlannerBenchmarkFactory(new SolverConfigContext(classLoader)).configure(templateFile, model);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlInputStream(InputStream templateIn) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlInputStream(templateIn, null);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlInputStream(InputStream templateIn, ClassLoader classLoader) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlInputStream(templateIn, null, classLoader);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlInputStream(InputStream templateIn, Object model) {
        return new FreemarkerXmlPlannerBenchmarkFactory().configure(templateIn, model);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlInputStream(InputStream templateIn, Object model, ClassLoader classLoader) {
        return new FreemarkerXmlPlannerBenchmarkFactory(new SolverConfigContext(classLoader)).configure(templateIn, model);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlReader(Reader templateReader) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlReader(templateReader, null);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlReader(Reader templateReader, ClassLoader classLoader) {
        return PlannerBenchmarkFactory.createFromFreemarkerXmlReader(templateReader, null, classLoader);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlReader(Reader templateReader, Object model) {
        return new FreemarkerXmlPlannerBenchmarkFactory().configure(templateReader, model);
    }

    public static PlannerBenchmarkFactory createFromFreemarkerXmlReader(Reader templateReader, Object model, ClassLoader classLoader) {
        return new FreemarkerXmlPlannerBenchmarkFactory(new SolverConfigContext(classLoader)).configure(templateReader, model);
    }

    public abstract PlannerBenchmarkConfig getPlannerBenchmarkConfig();

    public abstract PlannerBenchmark buildPlannerBenchmark();
}

