/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.core.impl.solver.io.XStreamConfigReader;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

public class PlannerBenchmarkConfigTest {
    @Test
    public void validNameWithUnderscoreAndSpace() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("Valid_name with space_and_underscore");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        config.validate();
    }

    @Test
    public void validNameWithJapanese() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("Valid name (\u6709\u52b9\u540d in Japanese)");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        config.validate();
    }

    @Test
    public void invalidNameWithSlash() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("slash/name");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).validate());
    }

    @Test
    public void invalidNameWithSuffixWhitespace() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("Suffixed with space ");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).validate());
    }

    @Test
    public void invalidNameWithPrefixWhitespace() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName(" prefixed with space");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).validate());
    }

    @Test
    public void noSolverConfigs() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setSolverBenchmarkConfigList(null);
        config.setSolverBenchmarkBluePrintConfigList(null);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).validate());
    }

    @Test
    public void nonUniqueSolverConfigName() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        String sbcName = "x";
        SolverBenchmarkConfig sbc1 = new SolverBenchmarkConfig();
        sbc1.setName("x");
        SolverBenchmarkConfig sbc2 = new SolverBenchmarkConfig();
        sbc2.setName("x");
        config.setSolverBenchmarkConfigList(Arrays.asList(sbc1, sbc2));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).generateSolverBenchmarkConfigNames());
    }

    @Test
    public void uniqueNamesGenerated() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        SolverBenchmarkConfig sbc1 = new SolverBenchmarkConfig();
        SolverBenchmarkConfig sbc2 = new SolverBenchmarkConfig();
        SolverBenchmarkConfig sbc3 = new SolverBenchmarkConfig();
        sbc3.setName("Config_1");
        List<SolverBenchmarkConfig> configs = Arrays.asList(sbc1, sbc2, sbc3);
        config.setSolverBenchmarkConfigList(configs);
        config.generateSolverBenchmarkConfigNames();
        Assert.assertEquals((Object)"Config_1", (Object)sbc3.getName());
        TreeSet<String> names = new TreeSet<String>();
        for (SolverBenchmarkConfig sc : configs) {
            names.add(sc.getName());
        }
        for (int i = 0; i < configs.size(); ++i) {
            Assert.assertTrue((boolean)names.contains("Config_" + i));
        }
    }

    @Test
    public void resolveParallelBenchmarkCountAutomatically() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        Assert.assertEquals((long)1L, (long)config.resolveParallelBenchmarkCountAutomatically(-1));
        Assert.assertEquals((long)1L, (long)config.resolveParallelBenchmarkCountAutomatically(0));
        Assert.assertEquals((long)1L, (long)config.resolveParallelBenchmarkCountAutomatically(1));
        Assert.assertEquals((long)1L, (long)config.resolveParallelBenchmarkCountAutomatically(2));
        Assert.assertEquals((long)2L, (long)config.resolveParallelBenchmarkCountAutomatically(3));
        Assert.assertEquals((long)2L, (long)config.resolveParallelBenchmarkCountAutomatically(4));
        Assert.assertEquals((long)3L, (long)config.resolveParallelBenchmarkCountAutomatically(5));
        Assert.assertEquals((long)4L, (long)config.resolveParallelBenchmarkCountAutomatically(6));
        Assert.assertEquals((long)9L, (long)config.resolveParallelBenchmarkCountAutomatically(17));
    }

    @Test
    public void resolveParallelBenchmarkCountFromFormula() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setParallelBenchmarkCount("availableProcessorCount+1");
        Assert.assertEquals((long)Runtime.getRuntime().availableProcessors(), (long)config.resolveParallelBenchmarkCount());
    }

    @Test
    public void parallelBenchmarkDisabledByDefault() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        Assert.assertEquals((long)1L, (long)config.resolveParallelBenchmarkCount());
    }

    @Test
    public void resolvedParallelBenchmarkCountNegative() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setParallelBenchmarkCount("-1");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).resolveParallelBenchmarkCount());
    }

    @Test
    public void calculateWarmUpTimeMillisSpentLimit() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setWarmUpHoursSpentLimit(Long.valueOf(1L));
        config.setWarmUpMinutesSpentLimit(Long.valueOf(2L));
        config.setWarmUpSecondsSpentLimit(Long.valueOf(5L));
        config.setWarmUpMillisecondsSpentLimit(Long.valueOf(753L));
        Assert.assertEquals((long)3725753L, (long)config.calculateWarmUpTimeMillisSpentLimit());
    }

    @Test
    public void xmlConfigFileRemainsSameAfterReadWrite() throws IOException {
        String benchmarkConfigResource = "org/optaplanner/benchmark/config/testdataBenchmarkConfigNoInheritence.xml";
        String originalXml = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(benchmarkConfigResource), (Charset)StandardCharsets.UTF_8);
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)benchmarkConfigResource);
        Assert.assertNotNull((Object)PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig).buildPlannerBenchmark((Object[])new TestdataSolution[]{new TestdataSolution()}));
        XStream xStream = XStreamConfigReader.buildXStreamPortable((ClassLoader)this.getClass().getClassLoader(), (Class[])new Class[]{PlannerBenchmarkConfig.class});
        xStream.setMode(1001);
        String savedXml = xStream.toXML((Object)benchmarkConfig);
        Assert.assertEquals((Object)originalXml.trim(), (Object)savedXml.trim());
    }
}

