/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.measurement;

import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;

public class ScoreDifferencePercentageTest {
    @Test
    public void calculateScoreDifferencePercentageException() {
        BendableScore score1 = BendableScore.of((int[])new int[]{1, 2, 3}, (int[])new int[]{4, 5});
        BendableScore score2 = BendableScore.of((int[])new int[]{1, 2}, (int[])new int[]{4, 5});
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2));
    }

    @Test
    public void calculateScoreDifferencePercentage() {
        double tolerance = 1.0E-5;
        SimpleScore score1 = SimpleScore.of((int)-100);
        SimpleScore score2 = SimpleScore.of((int)-100);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assert.assertEquals((double)0.0, (double)scoreDifferencePercentage.getPercentageLevels()[0], (double)tolerance);
        score1 = SimpleScore.of((int)100);
        score2 = SimpleScore.of((int)100);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assert.assertEquals((double)0.0, (double)scoreDifferencePercentage.getPercentageLevels()[0], (double)tolerance);
        score1 = SimpleScore.of((int)-100);
        score2 = SimpleScore.of((int)-10);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assert.assertEquals((double)0.9, (double)scoreDifferencePercentage.getPercentageLevels()[0], (double)tolerance);
        score1 = SimpleScore.of((int)100);
        score2 = SimpleScore.of((int)10);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assert.assertEquals((double)-0.9, (double)scoreDifferencePercentage.getPercentageLevels()[0], (double)tolerance);
        score1 = SimpleScore.of((int)-100);
        score2 = SimpleScore.of((int)-1);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assert.assertEquals((double)0.99, (double)scoreDifferencePercentage.getPercentageLevels()[0], (double)tolerance);
        score1 = SimpleScore.of((int)100);
        score2 = SimpleScore.of((int)1);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assert.assertEquals((double)-0.99, (double)scoreDifferencePercentage.getPercentageLevels()[0], (double)tolerance);
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-100, (int)-1);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        Assert.assertEquals((double)0.0, (double)scoreDifferencePercentage.getPercentageLevels()[0], (double)tolerance);
        Assert.assertEquals((double)0.0, (double)scoreDifferencePercentage.getPercentageLevels()[1], (double)tolerance);
        hardSoftScore1 = HardSoftScore.of((int)-100, (int)-100);
        hardSoftScore2 = HardSoftScore.of((int)-1, (int)-10);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        Assert.assertEquals((double)0.99, (double)scoreDifferencePercentage.getPercentageLevels()[0], (double)tolerance);
        Assert.assertEquals((double)0.9, (double)scoreDifferencePercentage.getPercentageLevels()[1], (double)tolerance);
        hardSoftScore1 = HardSoftScore.of((int)100, (int)100);
        hardSoftScore2 = HardSoftScore.of((int)1, (int)10);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        Assert.assertEquals((double)-0.99, (double)scoreDifferencePercentage.getPercentageLevels()[0], (double)tolerance);
        Assert.assertEquals((double)-0.9, (double)scoreDifferencePercentage.getPercentageLevels()[1], (double)tolerance);
        hardSoftScore1 = HardSoftScore.of((int)100, (int)-100);
        hardSoftScore2 = HardSoftScore.of((int)-100, (int)200);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        Assert.assertEquals((double)-2.0, (double)scoreDifferencePercentage.getPercentageLevels()[0], (double)tolerance);
        Assert.assertEquals((double)3.0, (double)scoreDifferencePercentage.getPercentageLevels()[1], (double)tolerance);
    }

    @Test
    public void add() {
        double tolerance = 1.0E-5;
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage2 = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        double[] levels = scoreDifferencePercentage.add(scoreDifferencePercentage2).getPercentageLevels();
        Assert.assertEquals((double)-2.0, (double)levels[0], (double)tolerance);
        Assert.assertEquals((double)-18.0, (double)levels[1], (double)tolerance);
    }

    @Test
    public void subtract() {
        double tolerance = 1.0E-5;
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage2 = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        double[] levels = scoreDifferencePercentage.subtract(scoreDifferencePercentage2).getPercentageLevels();
        Assert.assertEquals((double)0.0, (double)levels[0], (double)tolerance);
        Assert.assertEquals((double)0.0, (double)levels[1], (double)tolerance);
    }

    @Test
    public void multiply() {
        double tolerance = 1.0E-5;
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        double[] levels = scoreDifferencePercentage.multiply(3.14).getPercentageLevels();
        Assert.assertEquals((double)-3.14, (double)levels[0], (double)tolerance);
        Assert.assertEquals((double)-28.26, (double)levels[1], (double)tolerance);
        levels = scoreDifferencePercentage.multiply(-1.0).getPercentageLevels();
        Assert.assertEquals((double)1.0, (double)levels[0], (double)tolerance);
        Assert.assertEquals((double)9.0, (double)levels[1], (double)tolerance);
    }

    @Test
    public void divide() {
        double tolerance = 1.0E-5;
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        double[] levels = scoreDifferencePercentage.multiply(0.5).getPercentageLevels();
        Assert.assertEquals((double)-0.5, (double)levels[0], (double)tolerance);
        Assert.assertEquals((double)-4.5, (double)levels[1], (double)tolerance);
        levels = scoreDifferencePercentage.multiply(-1.0).getPercentageLevels();
        Assert.assertEquals((double)1.0, (double)levels[0], (double)tolerance);
        Assert.assertEquals((double)9.0, (double)levels[1], (double)tolerance);
    }

    @Test
    public void addWithWrongDimension() {
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        SimpleScore score1 = SimpleScore.of((int)-100);
        SimpleScore score2 = SimpleScore.of((int)-200);
        ScoreDifferencePercentage scoreDifferencePercentage2 = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> scoreDifferencePercentage.add(scoreDifferencePercentage2));
    }

    @Test
    public void subtractWithWrongDimension() {
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        SimpleScore score1 = SimpleScore.of((int)-100);
        SimpleScore score2 = SimpleScore.of((int)-200);
        ScoreDifferencePercentage scoreDifferencePercentage2 = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> scoreDifferencePercentage.subtract(scoreDifferencePercentage2));
    }
}

