/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.core.api.solver.DivertingClassLoader;
import org.optaplanner.core.config.phase.custom.CustomPhaseConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.phase.custom.NoChangeCustomPhaseCommand;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

class PlannerBenchmarkFactoryTest {
    private static File benchmarkTestDir;
    private static File benchmarkOutputTestDir;

    PlannerBenchmarkFactoryTest() {
    }

    @BeforeAll
    static void setup() throws IOException {
        benchmarkTestDir = new File("target/test/benchmarkTest/");
        benchmarkTestDir.mkdirs();
        new File(benchmarkTestDir, "input.xml").createNewFile();
        benchmarkOutputTestDir = new File(benchmarkTestDir, "output/");
        benchmarkOutputTestDir.mkdir();
    }

    @Test
    void createFromSolverConfigXmlResource() {
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromSolverConfigXmlResource((String)"org/optaplanner/core/config/solver/testdataSolverConfig.xml");
        TestdataSolution solution = new TestdataSolution("s1");
        solution.setEntityList(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        solution.setValueList(Arrays.asList(new TestdataValue("v1"), new TestdataValue("v2")));
        Assertions.assertThat((Object)benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution})).isNotNull();
        benchmarkFactory = PlannerBenchmarkFactory.createFromSolverConfigXmlResource((String)"org/optaplanner/core/config/solver/testdataSolverConfig.xml", (File)benchmarkOutputTestDir);
        Assertions.assertThat((Object)benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution})).isNotNull();
    }

    @Test
    void createFromSolverConfigXmlResource_classLoader() {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromSolverConfigXmlResource((String)"divertThroughClassLoader/org/optaplanner/core/api/solver/classloaderTestdataSolverConfig.xml", (ClassLoader)classLoader);
        TestdataSolution solution = new TestdataSolution("s1");
        solution.setEntityList(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        solution.setValueList(Arrays.asList(new TestdataValue("v1"), new TestdataValue("v2")));
        Assertions.assertThat((Object)benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution})).isNotNull();
        benchmarkFactory = PlannerBenchmarkFactory.createFromSolverConfigXmlResource((String)"divertThroughClassLoader/org/optaplanner/core/api/solver/classloaderTestdataSolverConfig.xml", (File)benchmarkOutputTestDir, (ClassLoader)classLoader);
        Assertions.assertThat((Object)benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution})).isNotNull();
    }

    @Test
    void problemIsNotASolutionInstance() {
        SolverConfig solverConfig = PlannerTestUtils.buildSolverConfig(TestdataSolution.class, (Class[])new Class[]{TestdataEntity.class});
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> benchmarkFactory.buildPlannerBenchmark((Object[])new String[]{"This is not a solution instance."}));
    }

    @Test
    void problemIsNull() {
        SolverConfig solverConfig = PlannerTestUtils.buildSolverConfig(TestdataSolution.class, (Class[])new Class[]{TestdataEntity.class});
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig));
        TestdataSolution solution = new TestdataSolution("s1");
        solution.setEntityList(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        solution.setValueList(Arrays.asList(new TestdataValue("v1"), new TestdataValue("v2")));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataSolution[]{solution, null}));
    }

    @Test
    void createFromXmlResource() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataBenchmarkConfig.xml");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assertions.assertThat((Object)plannerBenchmark).isNotNull();
        plannerBenchmark.benchmark();
    }

    @Test
    void createFromXmlResource_classLoader() {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlResource((String)"divertThroughClassLoader/org/optaplanner/benchmark/api/classloaderTestdataBenchmarkConfig.xml", (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assertions.assertThat((Object)plannerBenchmark).isNotNull();
        plannerBenchmark.benchmark();
    }

    @Test
    void createFromXmlResource_nonExisting() {
        String nonExistingBenchmarkConfigResource = "org/optaplanner/benchmark/api/nonExistingBenchmarkConfig.xml";
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/nonExistingBenchmarkConfig.xml")).withMessageContaining("org/optaplanner/benchmark/api/nonExistingBenchmarkConfig.xml");
    }

    @Test
    void createFromInvalidXmlResource_failsShowingBothResourceAndReason() {
        String invalidXmlBenchmarkConfigResource = "org/optaplanner/benchmark/api/invalidBenchmarkConfig.xml";
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> PlannerBenchmarkFactory.createFromXmlResource((String)"org/optaplanner/benchmark/api/invalidBenchmarkConfig.xml")).withMessageContaining("org/optaplanner/benchmark/api/invalidBenchmarkConfig.xml").withStackTraceContaining("invalidElementThatShouldNotBeHere");
    }

    @Test
    void createFromInvalidXmlFile_failsShowingBothPathAndReason() throws IOException {
        String invalidXmlBenchmarkConfigResource = "org/optaplanner/benchmark/api/invalidBenchmarkConfig.xml";
        File file = new File(benchmarkTestDir, "invalidBenchmarkConfig.xml");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/optaplanner/benchmark/api/invalidBenchmarkConfig.xml");){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> PlannerBenchmarkFactory.createFromXmlFile((File)file)).withMessageContaining(file.toString()).withStackTraceContaining("invalidElementThatShouldNotBeHere");
    }

    @Test
    void createFromXmlResource_uninitializedBestSolution() {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataBenchmarkConfig.xml");
        SolverBenchmarkConfig solverBenchmarkConfig = (SolverBenchmarkConfig)benchmarkConfig.getSolverBenchmarkConfigList().get(0);
        CustomPhaseConfig phaseConfig = new CustomPhaseConfig();
        phaseConfig.setCustomPhaseCommandClassList(Collections.singletonList(NoChangeCustomPhaseCommand.class));
        solverBenchmarkConfig.getSolverConfig().setPhaseConfigList(Collections.singletonList(phaseConfig));
        PlannerBenchmark plannerBenchmark = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig).buildPlannerBenchmark();
        Assertions.assertThat((Object)plannerBenchmark).isNotNull();
        plannerBenchmark.benchmark();
    }

    @Test
    void createFromXmlResource_subSingleCount() {
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)"org/optaplanner/benchmark/api/testdataBenchmarkConfig.xml");
        SolverBenchmarkConfig solverBenchmarkConfig = (SolverBenchmarkConfig)benchmarkConfig.getSolverBenchmarkConfigList().get(0);
        solverBenchmarkConfig.setSubSingleCount(Integer.valueOf(3));
        PlannerBenchmark plannerBenchmark = PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig).buildPlannerBenchmark();
        Assertions.assertThat((Object)plannerBenchmark).isNotNull();
        plannerBenchmark.benchmark();
    }

    @Test
    void createFromXmlFile() throws IOException {
        File file = new File(benchmarkTestDir, "testdataBenchmarkConfig.xml");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/optaplanner/benchmark/api/testdataBenchmarkConfig.xml");){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlFile((File)file);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assertions.assertThat((Object)plannerBenchmark).isNotNull();
        plannerBenchmark.benchmark();
    }

    @Test
    void createFromXmlFile_classLoader() throws IOException {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        File file = new File(benchmarkTestDir, "classloaderTestdataBenchmarkConfig.xml");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/optaplanner/benchmark/api/classloaderTestdataBenchmarkConfig.xml");){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromXmlFile((File)file, (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assertions.assertThat((Object)plannerBenchmark).isNotNull();
        plannerBenchmark.benchmark();
    }

    @Test
    void createFromFreemarkerXmlResource() {
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"org/optaplanner/benchmark/api/testdataBenchmarkConfigTemplate.xml.ftl");
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assertions.assertThat((Object)plannerBenchmark).isNotNull();
        plannerBenchmark.benchmark();
    }

    @Test
    void createFromFreemarkerXmlResource_classLoader() {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"divertThroughClassLoader/org/optaplanner/benchmark/api/classloaderTestdataBenchmarkConfigTemplate.xml.ftl", (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assertions.assertThat((Object)plannerBenchmark).isNotNull();
        plannerBenchmark.benchmark();
    }

    @Test
    void createFromFreemarkerXmlResource_nonExisting() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> PlannerBenchmarkFactory.createFromFreemarkerXmlResource((String)"org/optaplanner/benchmark/api/nonExistingBenchmarkConfigTemplate.xml.ftl"));
    }

    @Test
    void createFromFreemarkerXmlFile() throws IOException {
        File file = new File(benchmarkTestDir, "testdataBenchmarkConfigTemplate.xml.ftl");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/optaplanner/benchmark/api/testdataBenchmarkConfigTemplate.xml.ftl");){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlFile((File)file);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assertions.assertThat((Object)plannerBenchmark).isNotNull();
        plannerBenchmark.benchmark();
    }

    @Test
    void createFromFreemarkerXmlFile_classLoader() throws IOException {
        DivertingClassLoader classLoader = new DivertingClassLoader(this.getClass().getClassLoader());
        File file = new File(benchmarkTestDir, "classloaderTestdataBenchmarkConfigTemplate.xml.ftl");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/optaplanner/benchmark/api/classloaderTestdataBenchmarkConfigTemplate.xml.ftl");){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        PlannerBenchmarkFactory plannerBenchmarkFactory = PlannerBenchmarkFactory.createFromFreemarkerXmlFile((File)file, (ClassLoader)classLoader);
        PlannerBenchmark plannerBenchmark = plannerBenchmarkFactory.buildPlannerBenchmark();
        Assertions.assertThat((Object)plannerBenchmark).isNotNull();
        plannerBenchmark.benchmark();
    }
}

