/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.SolverBenchmarkFactory;
import org.optaplanner.core.config.solver.monitoring.SolverMetric;

class SolverBenchmarkFactoryTest {
    SolverBenchmarkFactoryTest() {
    }

    @Test
    void validNameWithUnderscoreAndSpace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Valid_name with space_and_underscore");
        config.setSubSingleCount(Integer.valueOf(1));
        this.validateConfig(config);
    }

    @Test
    void validNameWithJapanese() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Valid name (\u6709\u52b9\u540d in Japanese)");
        config.setSubSingleCount(Integer.valueOf(1));
        this.validateConfig(config);
    }

    @Test
    void invalidNameWithSlash() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("slash/name");
        config.setSubSingleCount(Integer.valueOf(1));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.validateConfig(config));
    }

    @Test
    void invalidNameWithSuffixWhitespace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("Suffixed with space ");
        config.setSubSingleCount(Integer.valueOf(1));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.validateConfig(config));
    }

    @Test
    void invalidNameWithPrefixWhitespace() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName(" prefixed with space");
        config.setSubSingleCount(Integer.valueOf(1));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.validateConfig(config));
    }

    @Test
    void validNonZeroSubSingleCount() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(Integer.valueOf(2));
        this.validateConfig(config);
    }

    @Test
    void validNullSubSingleCount() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(null);
        this.validateConfig(config);
    }

    @Test
    void invalidZeroSubSingleCount() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(Integer.valueOf(0));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.validateConfig(config));
    }

    @Test
    void defaultStatisticsAreUsedIfNotPresent() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(Integer.valueOf(0));
        SolverBenchmarkFactory solverBenchmarkFactory = new SolverBenchmarkFactory(config);
        ProblemBenchmarksConfig problemBenchmarksConfig = new ProblemBenchmarksConfig();
        Assertions.assertThat((List)solverBenchmarkFactory.getSolverMetrics(problemBenchmarksConfig)).isEqualTo(List.of(SolverMetric.BEST_SCORE));
    }

    @Test
    void problemStatisticsAreUsedIfPresent() {
        SolverBenchmarkConfig config = new SolverBenchmarkConfig();
        config.setName("name");
        config.setSubSingleCount(Integer.valueOf(0));
        SolverBenchmarkFactory solverBenchmarkFactory = new SolverBenchmarkFactory(config);
        ProblemBenchmarksConfig problemBenchmarksConfig = new ProblemBenchmarksConfig();
        problemBenchmarksConfig.setProblemStatisticTypeList(List.of(ProblemStatisticType.STEP_SCORE));
        problemBenchmarksConfig.setSingleStatisticTypeList(List.of(SingleStatisticType.CONSTRAINT_MATCH_TOTAL_BEST_SCORE));
        Assertions.assertThat((List)solverBenchmarkFactory.getSolverMetrics(problemBenchmarksConfig)).isEqualTo(List.of(SolverMetric.STEP_SCORE, SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE));
    }

    private void validateConfig(SolverBenchmarkConfig config) {
        SolverBenchmarkFactory solverBenchmarkFactory = new SolverBenchmarkFactory(config);
        solverBenchmarkFactory.validate();
    }
}

