/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.xsd;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.impl.xsd.XsdAggregator;
import org.optaplanner.core.impl.io.jaxb.GenericJaxbIO;
import org.xml.sax.SAXException;

class XsdAggregatorTest {
    private static final String VALID_BENCHMARK_CONFIG_XML = "validBenchmarkConfig.xml";

    XsdAggregatorTest() {
    }

    @Test
    void validateByMergedXsd() throws IOException {
        PlannerBenchmarkConfig plannerBenchmarkConfig;
        File solverXsd = this.getResourceAsFile("/solver.xsd");
        File benchmarkXsd = this.getResourceAsFile("/benchmark-with-import.xsd");
        File mergedBenchmarkXsd = File.createTempFile("benchmark_", ".xsd");
        String[] args = new String[]{solverXsd.getAbsolutePath(), benchmarkXsd.getAbsolutePath(), mergedBenchmarkXsd.getAbsolutePath()};
        XsdAggregator.main((String[])args);
        GenericJaxbIO jaxbIO = new GenericJaxbIO(PlannerBenchmarkConfig.class);
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(VALID_BENCHMARK_CONFIG_XML));){
            plannerBenchmarkConfig = (PlannerBenchmarkConfig)jaxbIO.readAndValidate((Reader)reader, this.readXmlSchemaFromFile(mergedBenchmarkXsd));
        }
        Assertions.assertThat((Object)plannerBenchmarkConfig).isNotNull();
    }

    private File getResourceAsFile(String classPathResource) {
        try {
            URL resourceURl = this.getClass().getResource(classPathResource);
            return new File(resourceURl.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Class path resource " + classPathResource + " is not a valid URI.", e);
        }
    }

    private Schema readXmlSchemaFromFile(File schemaFile) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            return schemaFactory.newSchema(schemaFile);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(String.format("Failed to read schema from a file (%s).", schemaFile), e);
        }
    }
}

