/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.config.report.BenchmarkReportConfig;
import org.optaplanner.benchmark.impl.aggregator.BenchmarkAggregator;
import org.optaplanner.benchmark.impl.loader.FileProblemProvider;
import org.optaplanner.benchmark.impl.loader.ProblemProvider;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.report.BenchmarkReportFactory;
import org.optaplanner.benchmark.impl.result.BenchmarkResultIO;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.random.RandomType;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedSolution;

class PlannerBenchmarkResultTest {
    private static final String TEST_PLANNER_BENCHMARK_RESULT = "testPlannerBenchmarkResult.xml";

    PlannerBenchmarkResultTest() {
    }

    @Test
    void createMergedResult() {
        PlannerBenchmarkResult p1 = new PlannerBenchmarkResult();
        p1.initSystemProperties();
        PlannerBenchmarkResult p2 = new PlannerBenchmarkResult();
        p2.initSystemProperties();
        SolverBenchmarkResult p1SolverX = new SolverBenchmarkResult(p1);
        p1SolverX.setName("Solver X");
        SolverConfig p1SolverConfigX = new SolverConfig();
        p1SolverConfigX.setRandomType(RandomType.JDK);
        p1SolverX.setSolverConfig(p1SolverConfigX);
        p1SolverX.setSingleBenchmarkResultList(new ArrayList());
        SolverBenchmarkResult p1SolverY = new SolverBenchmarkResult(p1);
        p1SolverY.setName("Solver Y");
        SolverConfig p1SolverConfigY = new SolverConfig();
        p1SolverConfigY.setRandomType(RandomType.MERSENNE_TWISTER);
        p1SolverY.setSolverConfig(p1SolverConfigY);
        p1SolverY.setSingleBenchmarkResultList(new ArrayList());
        SolverBenchmarkResult p2SolverZ = new SolverBenchmarkResult(p2);
        p2SolverZ.setName("Solver Z");
        SolverConfig p2SolverConfigZ = new SolverConfig();
        p2SolverConfigZ.setRandomType(RandomType.WELL1024A);
        p2SolverZ.setSolverConfig(p2SolverConfigZ);
        p2SolverZ.setSingleBenchmarkResultList(new ArrayList());
        ProblemBenchmarkResult p1ProblemA = new ProblemBenchmarkResult(p1);
        p1ProblemA.setProblemProvider((ProblemProvider)new FileProblemProvider(null, new File("problemA.xml")));
        p1ProblemA.setProblemStatisticList(Collections.emptyList());
        p1ProblemA.setSingleBenchmarkResultList(Collections.emptyList());
        p1ProblemA.setSingleBenchmarkResultList(new ArrayList());
        ProblemBenchmarkResult p1ProblemB = new ProblemBenchmarkResult(p1);
        p1ProblemB.setProblemProvider((ProblemProvider)new FileProblemProvider(null, new File("problemB.xml")));
        p1ProblemB.setProblemStatisticList(Collections.emptyList());
        p1ProblemB.setSingleBenchmarkResultList(Collections.emptyList());
        p1ProblemB.setSingleBenchmarkResultList(new ArrayList());
        ProblemBenchmarkResult p2ProblemA = new ProblemBenchmarkResult(p2);
        p2ProblemA.setProblemProvider((ProblemProvider)new FileProblemProvider(null, new File("problemA.xml")));
        p2ProblemA.setProblemStatisticList(Collections.emptyList());
        p2ProblemA.setSingleBenchmarkResultList(Collections.emptyList());
        p2ProblemA.setSingleBenchmarkResultList(new ArrayList());
        SingleBenchmarkResult p1SolverXProblemA = this.createSingleBenchmarkResult(p1SolverX, p1ProblemA, -1);
        this.createSubSingleBenchmarkResult(p1SolverXProblemA, 1);
        SingleBenchmarkResult p1SolverXProblemB = this.createSingleBenchmarkResult(p1SolverX, p1ProblemB, -20);
        SingleBenchmarkResult p1SolverYProblemA = this.createSingleBenchmarkResult(p1SolverY, p1ProblemA, -300);
        SingleBenchmarkResult p1SolverYProblemB = this.createSingleBenchmarkResult(p1SolverY, p1ProblemB, -4000);
        SingleBenchmarkResult p2SolverZProblemA = this.createSingleBenchmarkResult(p2SolverZ, p2ProblemA, -50000);
        PlannerBenchmarkResult mergedResult = PlannerBenchmarkResult.createMergedResult(Arrays.asList(p1SolverXProblemA, p1SolverXProblemB, p1SolverYProblemA, p1SolverYProblemB, p2SolverZProblemA));
        Assertions.assertThat((Boolean)mergedResult.getAggregation()).isTrue();
        List mergedProblemBenchmarkResultList = mergedResult.getUnifiedProblemBenchmarkResultList();
        List mergedSolverBenchmarkResultList = mergedResult.getSolverBenchmarkResultList();
        Assertions.assertThat((List)mergedSolverBenchmarkResultList).hasSize(3);
        Assertions.assertThat((String)((SolverBenchmarkResult)mergedSolverBenchmarkResultList.get(0)).getName()).isEqualTo("Solver X");
        Assertions.assertThat((String)((SolverBenchmarkResult)mergedSolverBenchmarkResultList.get(1)).getName()).isEqualTo("Solver Y");
        Assertions.assertThat((String)((SolverBenchmarkResult)mergedSolverBenchmarkResultList.get(2)).getName()).isEqualTo("Solver Z");
        Assertions.assertThat((List)mergedProblemBenchmarkResultList).hasSize(2);
        Assertions.assertThat((String)((ProblemBenchmarkResult)mergedProblemBenchmarkResultList.get(0)).getProblemProvider().getProblemName()).isEqualTo("problemA");
        Assertions.assertThat((String)((ProblemBenchmarkResult)mergedProblemBenchmarkResultList.get(1)).getProblemProvider().getProblemName()).isEqualTo("problemB");
    }

    protected SingleBenchmarkResult createSingleBenchmarkResult(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult, int score) {
        SingleBenchmarkResult singleBenchmarkResult = new SingleBenchmarkResult(solverBenchmarkResult, problemBenchmarkResult);
        solverBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
        problemBenchmarkResult.getSingleBenchmarkResultList().add(singleBenchmarkResult);
        singleBenchmarkResult.setAverageAndTotalScoreForTesting((Score)SimpleScore.of((int)score));
        singleBenchmarkResult.setSubSingleBenchmarkResultList(new ArrayList(1));
        this.createSubSingleBenchmarkResult(singleBenchmarkResult, 0);
        return singleBenchmarkResult;
    }

    protected SubSingleBenchmarkResult createSubSingleBenchmarkResult(SingleBenchmarkResult parent, int subSingleIndex) {
        SubSingleBenchmarkResult subSingleBenchmarkResult = new SubSingleBenchmarkResult(parent, subSingleIndex);
        subSingleBenchmarkResult.setPureSubSingleStatisticList(Collections.emptyList());
        parent.getSubSingleBenchmarkResultList().add(subSingleBenchmarkResult);
        return subSingleBenchmarkResult;
    }

    @Test
    void xmlReportRemainsSameAfterReadWrite() throws IOException {
        PlannerBenchmarkResult plannerBenchmarkResult;
        BenchmarkResultIO benchmarkResultIO = new BenchmarkResultIO();
        try (InputStreamReader reader = new InputStreamReader(PlannerBenchmarkResultTest.class.getResourceAsStream(TEST_PLANNER_BENCHMARK_RESULT), "UTF-8");){
            plannerBenchmarkResult = benchmarkResultIO.read((Reader)reader);
        }
        StringWriter stringWriter = new StringWriter();
        benchmarkResultIO.write(plannerBenchmarkResult, (Writer)stringWriter);
        String jaxbString = ((Object)stringWriter).toString();
        String originalXml = IOUtils.toString((InputStream)PlannerBenchmarkResultTest.class.getResourceAsStream(TEST_PLANNER_BENCHMARK_RESULT), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((String)jaxbString.trim()).isXmlEqualTo((CharSequence)originalXml.trim());
    }

    @Test
    void xmlReadBenchmarkResultAggregated() throws URISyntaxException, IOException {
        BenchmarkAggregator benchmarkAggregator = new BenchmarkAggregator();
        benchmarkAggregator.setBenchmarkDirectory(Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]).toFile());
        benchmarkAggregator.setBenchmarkReportConfig(new BenchmarkReportConfig());
        File plannerBenchmarkResultFile = new File(PlannerBenchmarkResultTest.class.getResource(TEST_PLANNER_BENCHMARK_RESULT).toURI());
        BenchmarkResultIO benchmarkResultIO = new BenchmarkResultIO();
        PlannerBenchmarkResult plannerBenchmarkResult = benchmarkResultIO.readPlannerBenchmarkResult(plannerBenchmarkResultFile);
        BenchmarkReportConfig benchmarkReportConfig = benchmarkAggregator.getBenchmarkReportConfig();
        BenchmarkReport benchmarkReport = new BenchmarkReportFactory(benchmarkReportConfig).buildBenchmarkReport(plannerBenchmarkResult);
        plannerBenchmarkResult.accumulateResults(benchmarkReport);
        PlannerBenchmarkResult aggregatedPlannerBenchmarkResult = benchmarkReport.getPlannerBenchmarkResult();
        Assertions.assertThat((List)aggregatedPlannerBenchmarkResult.getSolverBenchmarkResultList()).hasSize(6);
        Assertions.assertThat((List)aggregatedPlannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()).hasSize(2);
        Assertions.assertThat((Integer)aggregatedPlannerBenchmarkResult.getFailureCount()).isZero();
    }

    private static abstract class DummyDistanceNearbyMeter
    implements NearbyDistanceMeter<TestdataChainedSolution, TestdataChainedEntity> {
        private DummyDistanceNearbyMeter() {
        }
    }

    private static abstract class DummyIncrementalScoreCalculator
    implements IncrementalScoreCalculator<TestdataChainedSolution, SimpleScore> {
        private DummyIncrementalScoreCalculator() {
        }
    }
}

