/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.StatisticPoint;
import org.optaplanner.benchmark.impl.statistic.SubSingleStatistic;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

@Execution(value=ExecutionMode.CONCURRENT)
public abstract class AbstractSubSingleStatisticTest<Point_ extends StatisticPoint, SubSingleStatistic_ extends SubSingleStatistic<TestdataSolution, Point_>> {
    @Test
    void hibernation(@TempDir Path tempDir) {
        SubSingleBenchmarkResult subSingleBenchmarkResult = this.createSubStatistic(tempDir.toFile());
        Function<SubSingleBenchmarkResult, SubSingleStatistic_> constructor = this.getSubSingleStatisticConstructor();
        SubSingleStatistic subSingleStatistic = (SubSingleStatistic)constructor.apply(subSingleBenchmarkResult);
        subSingleStatistic.setPointList(this.getInputPoints());
        subSingleStatistic.hibernatePointList();
        SubSingleStatistic subSingleStatisticUnhibernated = (SubSingleStatistic)constructor.apply(subSingleBenchmarkResult);
        subSingleStatisticUnhibernated.unhibernatePointList();
        SoftAssertions.assertSoftly(softly -> this.runTest((SoftAssertions)softly, subSingleStatisticUnhibernated.getPointList()));
    }

    @Test
    void serialization(@TempDir Path tempDir) throws IOException, JAXBException {
        SubSingleBenchmarkResult subSingleBenchmarkResult = this.createSubStatistic(tempDir.toFile());
        Function<SubSingleBenchmarkResult, SubSingleStatistic_> constructor = this.getSubSingleStatisticConstructor();
        SubSingleStatistic subSingleStatistic = (SubSingleStatistic)constructor.apply(subSingleBenchmarkResult);
        subSingleStatistic.setPointList(this.getInputPoints());
        Class<?> clz = subSingleStatistic.getClass();
        QName qName = new QName(clz.getPackageName(), clz.getSimpleName());
        JAXBElement root = new JAXBElement(qName, clz, (Object)subSingleStatistic);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{subSingleStatistic.getClass()});
        Path tempFile = Files.createTempFile("optaplanner-", ".xml", new FileAttribute[0]);
        try (FileWriter writer = new FileWriter(tempFile.toFile());){
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)root, (Writer)writer);
        }
        catch (Exception e) {
            Assertions.fail((String)"Failed serializing statistic.", (Throwable)e);
        }
        Unmarshaller unmarshaller = context.createUnmarshaller();
        try {
            root = unmarshaller.unmarshal((Source)new StreamSource(tempFile.toFile()), clz);
        }
        catch (Exception e) {
            Assertions.fail((String)"Failed deserializing statistic.", (Throwable)e);
        }
        SubSingleStatistic deserialized = (SubSingleStatistic)root.getValue();
        Assertions.assertThat((Object)deserialized.getStatisticType()).isEqualTo((Object)subSingleStatistic.getStatisticType());
    }

    protected abstract Function<SubSingleBenchmarkResult, SubSingleStatistic_> getSubSingleStatisticConstructor();

    protected abstract List<Point_> getInputPoints();

    protected abstract void runTest(SoftAssertions var1, List<Point_> var2);

    private SubSingleBenchmarkResult createSubStatistic(File tempDirectory) {
        PlannerBenchmarkResult plannerBenchmarkResult = new PlannerBenchmarkResult();
        plannerBenchmarkResult.setBenchmarkReportDirectory(tempDirectory);
        ProblemBenchmarkResult problemBenchmarkResult = new ProblemBenchmarkResult(plannerBenchmarkResult);
        problemBenchmarkResult.setName(UUID.randomUUID().toString());
        SolverBenchmarkResult solverBenchmarkResult = new SolverBenchmarkResult(plannerBenchmarkResult);
        solverBenchmarkResult.setScoreDefinition(TestdataSolution.buildSolutionDescriptor().getScoreDefinition());
        solverBenchmarkResult.setName(UUID.randomUUID().toString());
        SingleBenchmarkResult singleBenchmarkResult = new SingleBenchmarkResult(solverBenchmarkResult, problemBenchmarkResult);
        SubSingleBenchmarkResult subSingleBenchmarkResult = new SubSingleBenchmarkResult(singleBenchmarkResult, 0);
        singleBenchmarkResult.setSubSingleBenchmarkResultList(Collections.singletonList(subSingleBenchmarkResult));
        problemBenchmarkResult.setSingleBenchmarkResultList(Collections.singletonList(singleBenchmarkResult));
        problemBenchmarkResult.makeDirs();
        return subSingleBenchmarkResult;
    }
}

