/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.measurement;

import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;

class ScoreDifferencePercentageTest {
    ScoreDifferencePercentageTest() {
    }

    @Test
    void calculateScoreDifferencePercentageException() {
        BendableScore score1 = BendableScore.of((int[])new int[]{1, 2, 3}, (int[])new int[]{4, 5});
        BendableScore score2 = BendableScore.of((int[])new int[]{1, 2}, (int[])new int[]{4, 5});
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2));
    }

    @Test
    void calculateScoreDifferencePercentage() {
        double tolerance = 1.0E-5;
        SimpleScore score1 = SimpleScore.of((int)-100);
        SimpleScore score2 = SimpleScore.of((int)-100);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[0]).isEqualTo(0.0, Offset.offset((Number)tolerance));
        score1 = SimpleScore.of((int)100);
        score2 = SimpleScore.of((int)100);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[0]).isEqualTo(0.0, Offset.offset((Number)tolerance));
        score1 = SimpleScore.of((int)-100);
        score2 = SimpleScore.of((int)-10);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[0]).isEqualTo(0.9, Offset.offset((Number)tolerance));
        score1 = SimpleScore.of((int)100);
        score2 = SimpleScore.of((int)10);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[0]).isEqualTo(-0.9, Offset.offset((Number)tolerance));
        score1 = SimpleScore.of((int)-100);
        score2 = SimpleScore.of((int)-1);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[0]).isEqualTo(0.99, Offset.offset((Number)tolerance));
        score1 = SimpleScore.of((int)100);
        score2 = SimpleScore.of((int)1);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[0]).isEqualTo(-0.99, Offset.offset((Number)tolerance));
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-100, (int)-1);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[0]).isEqualTo(0.0, Offset.offset((Number)tolerance));
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[1]).isEqualTo(0.0, Offset.offset((Number)tolerance));
        hardSoftScore1 = HardSoftScore.of((int)-100, (int)-100);
        hardSoftScore2 = HardSoftScore.of((int)-1, (int)-10);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[0]).isEqualTo(0.99, Offset.offset((Number)tolerance));
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[1]).isEqualTo(0.9, Offset.offset((Number)tolerance));
        hardSoftScore1 = HardSoftScore.of((int)100, (int)100);
        hardSoftScore2 = HardSoftScore.of((int)1, (int)10);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[0]).isEqualTo(-0.99, Offset.offset((Number)tolerance));
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[1]).isEqualTo(-0.9, Offset.offset((Number)tolerance));
        hardSoftScore1 = HardSoftScore.of((int)100, (int)-100);
        hardSoftScore2 = HardSoftScore.of((int)-100, (int)200);
        scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[0]).isEqualTo(-2.0, Offset.offset((Number)tolerance));
        Assertions.assertThat((double)scoreDifferencePercentage.getPercentageLevels()[1]).isEqualTo(3.0, Offset.offset((Number)tolerance));
    }

    @Test
    void add() {
        double tolerance = 1.0E-5;
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage2 = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        double[] levels = scoreDifferencePercentage.add(scoreDifferencePercentage2).getPercentageLevels();
        Assertions.assertThat((double)levels[0]).isEqualTo(-2.0, Offset.offset((Number)tolerance));
        Assertions.assertThat((double)levels[1]).isEqualTo(-18.0, Offset.offset((Number)tolerance));
    }

    @Test
    void subtract() {
        double tolerance = 1.0E-5;
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage2 = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        double[] levels = scoreDifferencePercentage.subtract(scoreDifferencePercentage2).getPercentageLevels();
        Assertions.assertThat((double)levels[0]).isEqualTo(0.0, Offset.offset((Number)tolerance));
        Assertions.assertThat((double)levels[1]).isEqualTo(0.0, Offset.offset((Number)tolerance));
    }

    @Test
    void multiply() {
        double tolerance = 1.0E-5;
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        double[] levels = scoreDifferencePercentage.multiply(3.14).getPercentageLevels();
        Assertions.assertThat((double)levels[0]).isEqualTo(-3.14, Offset.offset((Number)tolerance));
        Assertions.assertThat((double)levels[1]).isEqualTo(-28.26, Offset.offset((Number)tolerance));
        levels = scoreDifferencePercentage.multiply(-1.0).getPercentageLevels();
        Assertions.assertThat((double)levels[0]).isEqualTo(1.0, Offset.offset((Number)tolerance));
        Assertions.assertThat((double)levels[1]).isEqualTo(9.0, Offset.offset((Number)tolerance));
    }

    @Test
    void divide() {
        double tolerance = 1.0E-5;
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        double[] levels = scoreDifferencePercentage.multiply(0.5).getPercentageLevels();
        Assertions.assertThat((double)levels[0]).isEqualTo(-0.5, Offset.offset((Number)tolerance));
        Assertions.assertThat((double)levels[1]).isEqualTo(-4.5, Offset.offset((Number)tolerance));
        levels = scoreDifferencePercentage.multiply(-1.0).getPercentageLevels();
        Assertions.assertThat((double)levels[0]).isEqualTo(1.0, Offset.offset((Number)tolerance));
        Assertions.assertThat((double)levels[1]).isEqualTo(9.0, Offset.offset((Number)tolerance));
    }

    @Test
    void addWithWrongDimension() {
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        SimpleScore score1 = SimpleScore.of((int)-100);
        SimpleScore score2 = SimpleScore.of((int)-200);
        ScoreDifferencePercentage scoreDifferencePercentage2 = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> scoreDifferencePercentage.add(scoreDifferencePercentage2));
    }

    @Test
    void subtractWithWrongDimension() {
        HardSoftScore hardSoftScore1 = HardSoftScore.of((int)-100, (int)-1);
        HardSoftScore hardSoftScore2 = HardSoftScore.of((int)-200, (int)-10);
        ScoreDifferencePercentage scoreDifferencePercentage = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)hardSoftScore1, (Score)hardSoftScore2);
        SimpleScore score1 = SimpleScore.of((int)-100);
        SimpleScore score2 = SimpleScore.of((int)-200);
        ScoreDifferencePercentage scoreDifferencePercentage2 = ScoreDifferencePercentage.calculateScoreDifferencePercentage((Score)score1, (Score)score2);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> scoreDifferencePercentage.subtract(scoreDifferencePercentage2));
    }
}

