/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.report;

import freemarker.core.TemplateNumberFormat;
import freemarker.core.TemplateValueFormatException;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.Mockito;
import org.optaplanner.benchmark.impl.report.MillisecondDurationNumberFormatFactory;

class MillisecondDurationNumberFormatFactoryTest {
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final TemplateNumberFormat NUMBER_FORMAT = MillisecondDurationNumberFormatFactory.MillisecondDurationNumberFormat.INSTANCE;
    private final TemplateNumberModel templateNumberModel = (TemplateNumberModel)Mockito.mock(TemplateNumberModel.class);

    MillisecondDurationNumberFormatFactoryTest() {
    }

    @BeforeAll
    static void setExpectedLocale() {
        Locale.setDefault(Locale.forLanguageTag("cs_CZ"));
    }

    @AfterAll
    static void resetDefaultLocale() {
        Locale.setDefault(DEFAULT_LOCALE);
    }

    @ParameterizedTest(name="{0} milliseconds is formatted as ''{1}''")
    @CsvSource(delimiter=124, nullValues={"null"}, value={"      null | None.                                ", "         0 | 0 ms.                                ", "      2089 | 2.089 s. (2,089 ms.)                 ", "    346089 | 05:46.089 s. (346,089 ms.)           ", "  19346089 | 05:22:26.089 s. (19,346,089 ms.)     ", " 119346089 | 01:09:09:06.089 s. (119,346,089 ms.) "})
    void millisecondFormatting(Long millis, String translation) throws TemplateValueFormatException, TemplateModelException {
        Mockito.when((Object)this.templateNumberModel.getAsNumber()).thenReturn((Object)millis);
        String result = NUMBER_FORMAT.formatToPlainText(this.templateNumberModel);
        Assertions.assertThat((String)result).isEqualTo(translation);
    }
}

