/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.testgen.fact;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.constraint.drl.testgen.fact.TestGenAbstractValueProvider;
import org.optaplanner.constraint.drl.testgen.fact.TestGenFact;

class TestGenMapValueProvider
extends TestGenAbstractValueProvider<Map<?, ?>> {
    private final String identifier;
    private final Type[] typeArguments;
    private final Map<Object, TestGenFact> existingInstances;
    private final List<Class<?>> imports = new ArrayList();
    private final List<TestGenFact> requiredFacts;

    public TestGenMapValueProvider(Map<?, ?> value, String identifier, Type[] typeArguments, Map<Object, TestGenFact> existingInstances) {
        super(value);
        this.identifier = identifier;
        this.typeArguments = typeArguments;
        this.existingInstances = existingInstances;
        this.imports.add(HashMap.class);
        this.imports.add((Class)typeArguments[0]);
        this.imports.add((Class)typeArguments[1]);
        this.requiredFacts = value.entrySet().stream().flatMap(entry -> Stream.of((TestGenFact)existingInstances.get(entry.getKey()), (TestGenFact)existingInstances.get(entry.getValue()))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<TestGenFact> getRequiredFacts() {
        return this.requiredFacts;
    }

    @Override
    public List<Class<?>> getImports() {
        return this.imports;
    }

    @Override
    public void printSetup(StringBuilder sb) {
        String k = ((Class)this.typeArguments[0]).getSimpleName();
        String v = ((Class)this.typeArguments[1]).getSimpleName();
        sb.append(String.format("        HashMap<%s, %s> %s = new HashMap<>();\n", k, v, this.identifier));
        for (Map.Entry entry : ((Map)this.value).entrySet()) {
            sb.append(String.format("        //%s => %s\n", entry.getKey(), entry.getValue()));
            sb.append(String.format("        %s.put(%s, %s);\n", this.identifier, this.existingInstances.get(entry.getKey()), this.existingInstances.get(entry.getValue())));
        }
    }

    public String toString() {
        return this.identifier;
    }
}

