/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.testgen.reproducer;

import org.kie.api.runtime.KieSession;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolder;
import org.optaplanner.constraint.drl.testgen.TestGenDrlScoreDirector;
import org.optaplanner.constraint.drl.testgen.TestGenKieSessionJournal;
import org.optaplanner.constraint.drl.testgen.TestGenKieSessionListener;
import org.optaplanner.constraint.drl.testgen.operation.TestGenKieSessionFireAllRules;
import org.optaplanner.constraint.drl.testgen.operation.TestGenKieSessionInsert;
import org.optaplanner.constraint.drl.testgen.reproducer.TestGenCorruptedScoreException;
import org.optaplanner.constraint.drl.testgen.reproducer.TestGenOriginalProblemReproducer;
import org.optaplanner.core.api.score.Score;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenCorruptedScoreReproducer
implements TestGenOriginalProblemReproducer,
TestGenKieSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestGenCorruptedScoreReproducer.class);
    private final String analysis;
    private final TestGenDrlScoreDirector<?, ?> scoreDirector;

    public TestGenCorruptedScoreReproducer(String analysis, TestGenDrlScoreDirector<?, ?> scoreDirector) {
        this.analysis = analysis;
        this.scoreDirector = scoreDirector;
    }

    private static Score<?> extractScore(KieSession kieSession) {
        AbstractScoreHolder sh = (AbstractScoreHolder)kieSession.getGlobal("scoreHolder");
        return sh.extractScore(0);
    }

    @Override
    public void assertReproducible(TestGenKieSessionJournal journal, String contextDescription) {
        if (!this.isReproducible(journal)) {
            throw new IllegalStateException(contextDescription + " The score is not corrupted.");
        }
    }

    @Override
    public boolean isReproducible(TestGenKieSessionJournal journal) {
        journal.addListener(this);
        try {
            journal.replay(this.scoreDirector.createKieSession());
            return false;
        }
        catch (TestGenCorruptedScoreException e) {
            return true;
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("No fact handle for ")) {
                LOGGER.debug("    Can't remove insert: {}", (Object)e.toString());
            } else if (e.getMessage() != null && e.getMessage().startsWith("Error evaluating constraint '")) {
                LOGGER.debug("    Can't drop field setup: {}", (Object)e.toString());
            } else {
                LOGGER.info("Unexpected exception", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public void afterFireAllRules(KieSession kieSession, TestGenKieSessionJournal journal, TestGenKieSessionFireAllRules fire) {
        KieSession uncorruptedSession = this.scoreDirector.createKieSession();
        for (TestGenKieSessionInsert insert : journal.getInitialInserts()) {
            Object object = insert.getFact().getInstance();
            uncorruptedSession.insert(object);
        }
        uncorruptedSession.fireAllRules();
        uncorruptedSession.dispose();
        Score<?> uncorruptedScore = TestGenCorruptedScoreReproducer.extractScore(uncorruptedSession);
        Score<?> workingScore = TestGenCorruptedScoreReproducer.extractScore(kieSession);
        if (!workingScore.equals(uncorruptedScore)) {
            LOGGER.debug("    Score: working[{}], uncorrupted[{}]", workingScore, uncorruptedScore);
            throw new TestGenCorruptedScoreException(workingScore, uncorruptedScore);
        }
    }

    public String toString() {
        return this.analysis;
    }
}

