/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolderTest;
import org.optaplanner.constraint.drl.holder.BendableLongScoreHolderImpl;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScoreHolder;
import org.optaplanner.core.api.score.constraint.Indictment;

class BendableLongScoreHolderImplTest
extends AbstractScoreHolderTest<BendableLongScore> {
    BendableLongScoreHolderImplTest() {
    }

    @Test
    void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        BendableLongScoreHolderImpl scoreHolder = new BendableLongScoreHolderImpl(constraintMatchEnabled, 1, 2);
        RuleContext hard1 = this.mockRuleContext("hard1", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard1, 0, -1L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableLongScore.of((long[])new long[]{-1L}, (long[])new long[]{0L, 0L}));
        RuleContext hard2Undo = this.mockRuleContext("hard2Undo", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard2Undo, 0, -8L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableLongScore.of((long[])new long[]{-9L}, (long[])new long[]{0L, 0L}));
        this.callOnDelete(hard2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableLongScore.of((long[])new long[]{-1L}, (long[])new long[]{0L, 0L}));
        RuleContext medium1 = this.mockRuleContext("medium1", new Object[0]);
        scoreHolder.addSoftConstraintMatch(medium1, 0, -10L);
        this.callOnUpdate(medium1);
        scoreHolder.addSoftConstraintMatch(medium1, 0, -20L);
        RuleContext soft1 = this.mockRuleContext("soft1", DEFAULT_JUSTIFICATION, OTHER_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft1, 1, -100L);
        this.callOnUpdate(soft1);
        scoreHolder.addSoftConstraintMatch(soft1, 1, -300L);
        RuleContext multi1 = this.mockRuleContext("multi1", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi1, new long[]{-1000L}, new long[]{-10000L, -100000L});
        this.callOnUpdate(multi1);
        scoreHolder.addMultiConstraintMatch(multi1, new long[]{-4000L}, new long[]{-50000L, -600000L});
        RuleContext hard3 = this.mockRuleContext("hard3", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard3, 0, -1000000L);
        this.callOnUpdate(hard3);
        scoreHolder.addHardConstraintMatch(hard3, 0, -7000000L);
        RuleContext soft2Undo = this.mockRuleContext("soft2Undo", UNDO_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft2Undo, 1, -99L);
        this.callOnDelete(soft2Undo);
        RuleContext multi2Undo = this.mockRuleContext("multi2Undo", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi2Undo, new long[]{-999L}, new long[]{-999L, -999L});
        this.callOnDelete(multi2Undo);
        RuleContext medium2Undo = this.mockRuleContext("medium2Undo", new Object[0]);
        scoreHolder.addSoftConstraintMatch(medium2Undo, 0, -9999L);
        this.callOnDelete(medium2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableLongScore.of((long[])new long[]{-7004001L}, (long[])new long[]{-50020L, -600300L}));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(-7)).isEqualTo((Object)BendableLongScore.ofUninitialized((int)-7, (long[])new long[]{-7004001L}, (long[])new long[]{-50020L, -600300L}));
        if (constraintMatchEnabled) {
            Assertions.assertThat((Comparable)((BendableLongScore)this.findConstraintMatchTotal(scoreHolder, "hard1").getScore())).isEqualTo((Object)BendableLongScore.of((long[])new long[]{-1L}, (long[])new long[]{0L, 0L}));
            Assertions.assertThat((Comparable)((BendableLongScore)((Indictment)scoreHolder.getIndictmentMap().get(OTHER_JUSTIFICATION)).getScore())).isEqualTo((Object)BendableLongScore.of((long[])new long[]{0L}, (long[])new long[]{0L, -300L}));
            Assertions.assertThat((Object)((Indictment)scoreHolder.getIndictmentMap().get(UNDO_JUSTIFICATION))).isNull();
        }
    }

    @Test
    void rewardPenalizeWithConstraintMatch() {
        this.rewardPenalize(true);
    }

    @Test
    void rewardPenalizeWithoutConstraintMatch() {
        this.rewardPenalize(false);
    }

    public void rewardPenalize(boolean constraintMatchEnabled) {
        BendableLongScoreHolderImpl scoreHolder = new BendableLongScoreHolderImpl(constraintMatchEnabled, 1, 2);
        Rule hard1 = this.mockRule("hard1");
        scoreHolder.configureConstraintWeight(hard1, BendableLongScore.ofHard((int)1, (int)2, (int)0, (long)10L));
        Rule hard2 = this.mockRule("hard2");
        scoreHolder.configureConstraintWeight(hard2, BendableLongScore.ofHard((int)1, (int)2, (int)0, (long)100L));
        Rule medium1 = this.mockRule("medium1");
        scoreHolder.configureConstraintWeight(medium1, BendableLongScore.ofSoft((int)1, (int)2, (int)0, (long)10L));
        Rule soft1 = this.mockRule("soft1");
        scoreHolder.configureConstraintWeight(soft1, BendableLongScore.ofSoft((int)1, (int)2, (int)1, (long)10L));
        Rule soft2 = this.mockRule("soft2");
        scoreHolder.configureConstraintWeight(soft2, BendableLongScore.ofSoft((int)1, (int)2, (int)1, (long)100L));
        scoreHolder.penalize(this.mockRuleContext(hard1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableLongScore.of((long[])new long[]{-10L}, (long[])new long[]{0L, 0L}));
        scoreHolder.penalize(this.mockRuleContext(hard2, new Object[0]), 2L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableLongScore.of((long[])new long[]{-210L}, (long[])new long[]{0L, 0L}));
        scoreHolder.penalize(this.mockRuleContext(medium1, new Object[0]), 9L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableLongScore.of((long[])new long[]{-210L}, (long[])new long[]{-90L, 0L}));
        scoreHolder.reward(this.mockRuleContext(soft1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableLongScore.of((long[])new long[]{-210L}, (long[])new long[]{-90L, 10L}));
        scoreHolder.reward(this.mockRuleContext(soft2, new Object[0]), 3L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableLongScore.of((long[])new long[]{-210L}, (long[])new long[]{-90L, 310L}));
    }

    @Test
    void failFastHardLevel() {
        BendableLongScoreHolderImpl scoreHolder = new BendableLongScoreHolderImpl(false, 2, 5);
        RuleContext rule = this.mockRuleContext("rule", new Object[0]);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> BendableLongScoreHolderImplTest.lambda$failFastHardLevel$0((BendableLongScoreHolder)scoreHolder, rule));
    }

    @Test
    void failFastSoftLevel() {
        BendableLongScoreHolderImpl scoreHolder = new BendableLongScoreHolderImpl(false, 5, 2);
        RuleContext rule = this.mockRuleContext("rule", new Object[0]);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> BendableLongScoreHolderImplTest.lambda$failFastSoftLevel$1((BendableLongScoreHolder)scoreHolder, rule));
    }

    private static /* synthetic */ void lambda$failFastSoftLevel$1(BendableLongScoreHolder scoreHolder, RuleContext rule) throws Throwable {
        scoreHolder.addSoftConstraintMatch(rule, 3, -1L);
    }

    private static /* synthetic */ void lambda$failFastHardLevel$0(BendableLongScoreHolder scoreHolder, RuleContext rule) throws Throwable {
        scoreHolder.addHardConstraintMatch(rule, 3, -1L);
    }
}

