/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolderTest;
import org.optaplanner.constraint.drl.holder.HardSoftScoreHolderImpl;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.constraint.Indictment;

class HardSoftScoreHolderImplTest
extends AbstractScoreHolderTest<HardSoftScore> {
    HardSoftScoreHolderImplTest() {
    }

    @Test
    void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        HardSoftScoreHolderImpl scoreHolder = new HardSoftScoreHolderImpl(constraintMatchEnabled);
        RuleContext hard1 = this.mockRuleContext("hard1", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard1, -1);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)-1, (int)0));
        RuleContext hard2Undo = this.mockRuleContext("hard2Undo", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard2Undo, -8);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)-9, (int)0));
        this.callOnDelete(hard2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)-1, (int)0));
        RuleContext soft1 = this.mockRuleContext("soft1", DEFAULT_JUSTIFICATION, OTHER_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft1, -10);
        this.callOnUpdate(soft1);
        scoreHolder.addSoftConstraintMatch(soft1, -20);
        RuleContext multi1 = this.mockRuleContext("multi1", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi1, -100, -1000);
        this.callOnUpdate(multi1);
        scoreHolder.addMultiConstraintMatch(multi1, -300, -4000);
        RuleContext hard3 = this.mockRuleContext("hard3", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard3, -10000);
        this.callOnUpdate(hard3);
        scoreHolder.addHardConstraintMatch(hard3, -50000);
        RuleContext soft2Undo = this.mockRuleContext("soft2Undo", UNDO_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft2Undo, -99);
        this.callOnDelete(soft2Undo);
        RuleContext multi2Undo = this.mockRuleContext("multi2Undo", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi2Undo, -999, -999);
        this.callOnDelete(multi2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)-50301, (int)-4020));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(-7)).isEqualTo((Object)HardSoftScore.ofUninitialized((int)-7, (int)-50301, (int)-4020));
        if (constraintMatchEnabled) {
            Assertions.assertThat((Comparable)((HardSoftScore)this.findConstraintMatchTotal(scoreHolder, "hard1").getScore())).isEqualTo((Object)HardSoftScore.of((int)-1, (int)0));
            Assertions.assertThat((Comparable)((HardSoftScore)((Indictment)scoreHolder.getIndictmentMap().get(OTHER_JUSTIFICATION)).getScore())).isEqualTo((Object)HardSoftScore.of((int)0, (int)-20));
            Assertions.assertThat((Object)((Indictment)scoreHolder.getIndictmentMap().get(UNDO_JUSTIFICATION))).isNull();
        }
    }

    @Test
    void rewardPenalizeWithConstraintMatch() {
        this.rewardPenalize(true);
    }

    @Test
    void rewardPenalizeWithoutConstraintMatch() {
        this.rewardPenalize(false);
    }

    public void rewardPenalize(boolean constraintMatchEnabled) {
        HardSoftScoreHolderImpl scoreHolder = new HardSoftScoreHolderImpl(constraintMatchEnabled);
        Rule hard1 = this.mockRule("hard1");
        scoreHolder.configureConstraintWeight(hard1, HardSoftScore.ofHard((int)10));
        Rule hard2 = this.mockRule("hard2");
        scoreHolder.configureConstraintWeight(hard2, HardSoftScore.ofHard((int)100));
        Rule soft1 = this.mockRule("soft1");
        scoreHolder.configureConstraintWeight(soft1, HardSoftScore.ofSoft((int)10));
        Rule soft2 = this.mockRule("soft2");
        scoreHolder.configureConstraintWeight(soft2, HardSoftScore.ofSoft((int)100));
        scoreHolder.penalize(this.mockRuleContext(hard1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)-10, (int)0));
        scoreHolder.penalize(this.mockRuleContext(hard2, new Object[0]), 2);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)-210, (int)0));
        scoreHolder.reward(this.mockRuleContext(soft1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)-210, (int)10));
        scoreHolder.reward(this.mockRuleContext(soft2, new Object[0]), 3);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)-210, (int)310));
    }
}

