/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolderTest;
import org.optaplanner.constraint.drl.holder.SimpleScoreHolderImpl;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;

class SimpleScoreHolderImplTest
extends AbstractScoreHolderTest<SimpleScore> {
    SimpleScoreHolderImplTest() {
    }

    @Test
    void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        SimpleScoreHolderImpl scoreHolder = new SimpleScoreHolderImpl(constraintMatchEnabled);
        RuleContext scoreRule1 = this.mockRuleContext("scoreRule1", new Object[0]);
        scoreHolder.addConstraintMatch(scoreRule1, -1000);
        RuleContext scoreRule2 = this.mockRuleContext("scoreRule2", new Object[0]);
        scoreHolder.addConstraintMatch(scoreRule2, -200);
        this.callOnDelete(scoreRule2);
        RuleContext scoreRule3 = this.mockRuleContext("scoreRule3", new Object[0]);
        scoreHolder.addConstraintMatch(scoreRule3, -30);
        this.callOnUpdate(scoreRule3);
        scoreHolder.addConstraintMatch(scoreRule3, -3);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleScore.ofUninitialized((int)0, (int)-1003));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(-7)).isEqualTo((Object)SimpleScore.ofUninitialized((int)-7, (int)-1003));
        if (constraintMatchEnabled) {
            Assertions.assertThat((Comparable)((SimpleScore)this.findConstraintMatchTotal(scoreHolder, "scoreRule1").getScore())).isEqualTo((Object)SimpleScore.of((int)-1000));
        }
    }

    @Test
    void rewardPenalizeWithConstraintMatch() {
        this.rewardPenalize(true);
    }

    @Test
    void rewardPenalizeWithoutConstraintMatch() {
        this.rewardPenalize(false);
    }

    public void rewardPenalize(boolean constraintMatchEnabled) {
        SimpleScoreHolderImpl scoreHolder = new SimpleScoreHolderImpl(constraintMatchEnabled);
        Rule constraint1 = this.mockRule("constraint1");
        scoreHolder.configureConstraintWeight(constraint1, SimpleScore.of((int)10));
        Rule constraint2 = this.mockRule("constraint2");
        scoreHolder.configureConstraintWeight(constraint2, SimpleScore.of((int)100));
        scoreHolder.penalize(this.mockRuleContext(constraint1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)-10));
        scoreHolder.penalize(this.mockRuleContext(constraint2, new Object[0]), 2);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)-210));
        scoreHolder = new SimpleScoreHolderImpl(constraintMatchEnabled);
        Rule constraint3 = this.mockRule("constraint3");
        scoreHolder.configureConstraintWeight(constraint3, SimpleScore.of((int)10));
        Rule constraint4 = this.mockRule("constraint4");
        scoreHolder.configureConstraintWeight(constraint4, SimpleScore.of((int)100));
        scoreHolder.reward(this.mockRuleContext(constraint3, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)10));
        scoreHolder.reward(this.mockRuleContext(constraint4, new Object[0]), 3);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)310));
    }
}

