/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl;

import java.io.File;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.drl.DrlScoreDirectorFactoryService;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

class DrlScoreDirectorFactoryServiceTest {
    DrlScoreDirectorFactoryServiceTest() {
    }

    private ScoreDirectorFactory<TestdataSolution> buildScoreDirectoryFactory(ScoreDirectorFactoryConfig config) {
        Supplier supplier = new DrlScoreDirectorFactoryService().buildScoreDirectorFactory(this.getClass().getClassLoader(), TestdataSolution.buildSolutionDescriptor(), config);
        if (supplier == null) {
            return null;
        }
        return (ScoreDirectorFactory)supplier.get();
    }

    @Test
    void invalidDrlResource_throwsException() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig().withScoreDrls(new String[]{"org/optaplanner/constraint/drl/invalidDroolsConstraints.drl"});
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> this.buildScoreDirectoryFactory(config)).withMessageContaining("scoreDrl").withRootCauseInstanceOf(RuntimeException.class);
    }

    @Test
    void nonExistingDrlResource_throwsException() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig().withScoreDrls(new String[]{"nonExisting.drl"});
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> this.buildScoreDirectoryFactory(config)).withMessageContaining("scoreDrl");
    }

    @Test
    void nonExistingDrlFile_throwsException() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig().withScoreDrlFiles(new File[]{new File("nonExisting.drl")});
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> this.buildScoreDirectoryFactory(config)).withMessageContaining("scoreDrl");
    }
}

