/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.solutionproperties.TestdataNoProblemFactPropertySolution;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

class SolutionDescriptorTest {
    SolutionDescriptorTest() {
    }

    @Test
    void noProblemFactPropertyWithDroolsScoreCalculation() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> SolutionDescriptorTest.buildSolverFactoryWithDroolsScoreDirector(TestdataNoProblemFactPropertySolution.class, TestdataEntity.class));
    }

    private static <Solution_> SolverFactory<Solution_> buildSolverFactoryWithDroolsScoreDirector(Class<Solution_> solutionClass, Class<?> ... entityClasses) {
        SolverConfig solverConfig = PlannerTestUtils.buildSolverConfig(solutionClass, (Class[])entityClasses);
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = solverConfig.getScoreDirectorFactoryConfig();
        scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(null);
        scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList("org/optaplanner/constraint/drl/dummySimpleScoreDroolsConstraints.drl"));
        return SolverFactory.create((SolverConfig)solverConfig);
    }
}

