/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolderTest;
import org.optaplanner.constraint.drl.holder.BendableScoreHolderImpl;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendable.BendableScoreHolder;
import org.optaplanner.core.api.score.constraint.Indictment;

class BendableScoreHolderImplTest
extends AbstractScoreHolderTest {
    BendableScoreHolderImplTest() {
    }

    @Test
    void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        BendableScoreHolderImpl scoreHolder = new BendableScoreHolderImpl(constraintMatchEnabled, 1, 2);
        RuleContext hard1 = this.mockRuleContext("hard1", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard1, 0, -1);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableScore.of((int[])new int[]{-1}, (int[])new int[]{0, 0}));
        RuleContext hard2Undo = this.mockRuleContext("hard2Undo", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard2Undo, 0, -8);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableScore.of((int[])new int[]{-9}, (int[])new int[]{0, 0}));
        this.callOnDelete(hard2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableScore.of((int[])new int[]{-1}, (int[])new int[]{0, 0}));
        RuleContext medium1 = this.mockRuleContext("medium1", new Object[0]);
        scoreHolder.addSoftConstraintMatch(medium1, 0, -10);
        this.callOnUpdate(medium1);
        scoreHolder.addSoftConstraintMatch(medium1, 0, -20);
        RuleContext soft1 = this.mockRuleContext("soft1", DEFAULT_JUSTIFICATION, OTHER_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft1, 1, -100);
        this.callOnUpdate(soft1);
        scoreHolder.addSoftConstraintMatch(soft1, 1, -300);
        RuleContext multi1 = this.mockRuleContext("multi1", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi1, new int[]{-1000}, new int[]{-10000, -100000});
        this.callOnUpdate(multi1);
        scoreHolder.addMultiConstraintMatch(multi1, new int[]{-4000}, new int[]{-50000, -600000});
        RuleContext hard3 = this.mockRuleContext("hard3", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard3, 0, -1000000);
        this.callOnUpdate(hard3);
        scoreHolder.addHardConstraintMatch(hard3, 0, -7000000);
        RuleContext soft2Undo = this.mockRuleContext("soft2Undo", UNDO_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft2Undo, 1, -99);
        this.callOnDelete(soft2Undo);
        RuleContext multi2Undo = this.mockRuleContext("multi2Undo", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi2Undo, new int[]{-999}, new int[]{-999, -999});
        this.callOnDelete(multi2Undo);
        RuleContext medium2Undo = this.mockRuleContext("medium2Undo", new Object[0]);
        scoreHolder.addSoftConstraintMatch(medium2Undo, 0, -9999);
        this.callOnDelete(medium2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableScore.of((int[])new int[]{-7004001}, (int[])new int[]{-50020, -600300}));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(-7)).isEqualTo((Object)BendableScore.ofUninitialized((int)-7, (int[])new int[]{-7004001}, (int[])new int[]{-50020, -600300}));
        if (constraintMatchEnabled) {
            Assertions.assertThat((Comparable)this.findConstraintMatchTotal(scoreHolder, "hard1").getScore()).isEqualTo((Object)BendableScore.of((int[])new int[]{-1}, (int[])new int[]{0, 0}));
            Assertions.assertThat((Comparable)((BendableScore)((Indictment)scoreHolder.getIndictmentMap().get(OTHER_JUSTIFICATION)).getScore())).isEqualTo((Object)BendableScore.of((int[])new int[]{0}, (int[])new int[]{0, -300}));
            Assertions.assertThat((Object)((Indictment)scoreHolder.getIndictmentMap().get(UNDO_JUSTIFICATION))).isNull();
        }
    }

    @Test
    void rewardPenalizeWithConstraintMatch() {
        this.rewardPenalize(true);
    }

    @Test
    void rewardPenalizeWithoutConstraintMatch() {
        this.rewardPenalize(false);
    }

    public void rewardPenalize(boolean constraintMatchEnabled) {
        BendableScoreHolderImpl scoreHolder = new BendableScoreHolderImpl(constraintMatchEnabled, 1, 2);
        Rule hard1 = this.mockRule("hard1");
        scoreHolder.configureConstraintWeight(hard1, BendableScore.ofHard((int)1, (int)2, (int)0, (int)10));
        Rule hard2 = this.mockRule("hard2");
        scoreHolder.configureConstraintWeight(hard2, BendableScore.ofHard((int)1, (int)2, (int)0, (int)100));
        Rule medium1 = this.mockRule("medium1");
        scoreHolder.configureConstraintWeight(medium1, BendableScore.ofSoft((int)1, (int)2, (int)0, (int)10));
        Rule soft1 = this.mockRule("soft1");
        scoreHolder.configureConstraintWeight(soft1, BendableScore.ofSoft((int)1, (int)2, (int)1, (int)10));
        Rule soft2 = this.mockRule("soft2");
        scoreHolder.configureConstraintWeight(soft2, BendableScore.ofSoft((int)1, (int)2, (int)1, (int)100));
        scoreHolder.penalize(this.mockRuleContext(hard1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableScore.of((int[])new int[]{-10}, (int[])new int[]{0, 0}));
        scoreHolder.penalize(this.mockRuleContext(hard2, new Object[0]), 2);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableScore.of((int[])new int[]{-210}, (int[])new int[]{0, 0}));
        scoreHolder.penalize(this.mockRuleContext(medium1, new Object[0]), 9);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableScore.of((int[])new int[]{-210}, (int[])new int[]{-90, 0}));
        scoreHolder.reward(this.mockRuleContext(soft1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableScore.of((int[])new int[]{-210}, (int[])new int[]{-90, 10}));
        scoreHolder.reward(this.mockRuleContext(soft2, new Object[0]), 3);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)BendableScore.of((int[])new int[]{-210}, (int[])new int[]{-90, 310}));
    }

    @Test
    void failFastHardLevel() {
        BendableScoreHolderImpl scoreHolder = new BendableScoreHolderImpl(false, 2, 5);
        RuleContext rule = this.mockRuleContext("rule", new Object[0]);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> BendableScoreHolderImplTest.lambda$failFastHardLevel$0((BendableScoreHolder)scoreHolder, rule));
    }

    @Test
    void failFastSoftLevel() {
        BendableScoreHolderImpl scoreHolder = new BendableScoreHolderImpl(false, 5, 2);
        RuleContext rule = this.mockRuleContext("rule", new Object[0]);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> BendableScoreHolderImplTest.lambda$failFastSoftLevel$1((BendableScoreHolder)scoreHolder, rule));
    }

    private static /* synthetic */ void lambda$failFastSoftLevel$1(BendableScoreHolder scoreHolder, RuleContext rule) throws Throwable {
        scoreHolder.addSoftConstraintMatch(rule, 3, -1);
    }

    private static /* synthetic */ void lambda$failFastHardLevel$0(BendableScoreHolder scoreHolder, RuleContext rule) throws Throwable {
        scoreHolder.addHardConstraintMatch(rule, 3, -1);
    }
}

