/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolderTest;
import org.optaplanner.constraint.drl.holder.SimpleLongScoreHolderImpl;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;

class SimpleLongScoreHolderImplTest
extends AbstractScoreHolderTest<SimpleLongScore> {
    SimpleLongScoreHolderImplTest() {
    }

    @Test
    void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        SimpleLongScoreHolderImpl scoreHolder = new SimpleLongScoreHolderImpl(constraintMatchEnabled);
        RuleContext scoreRule1 = this.mockRuleContext("scoreRule1", new Object[0]);
        scoreHolder.addConstraintMatch(scoreRule1, -1000L);
        RuleContext scoreRule2 = this.mockRuleContext("scoreRule2", new Object[0]);
        scoreHolder.addConstraintMatch(scoreRule2, -200L);
        this.callOnDelete(scoreRule2);
        RuleContext scoreRule3 = this.mockRuleContext("scoreRule3", new Object[0]);
        scoreHolder.addConstraintMatch(scoreRule3, -30L);
        this.callOnUpdate(scoreRule3);
        scoreHolder.addConstraintMatch(scoreRule3, -3L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleLongScore.ofUninitialized((int)0, (long)-1003L));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(-7)).isEqualTo((Object)SimpleLongScore.ofUninitialized((int)-7, (long)-1003L));
        if (constraintMatchEnabled) {
            Assertions.assertThat((Comparable)((SimpleLongScore)this.findConstraintMatchTotal(scoreHolder, "scoreRule1").getScore())).isEqualTo((Object)SimpleLongScore.of((long)-1000L));
        }
    }

    @Test
    void rewardPenalizeWithConstraintMatch() {
        this.rewardPenalize(true);
    }

    @Test
    void rewardPenalizeWithoutConstraintMatch() {
        this.rewardPenalize(false);
    }

    public void rewardPenalize(boolean constraintMatchEnabled) {
        SimpleLongScoreHolderImpl scoreHolder = new SimpleLongScoreHolderImpl(constraintMatchEnabled);
        Rule constraint1 = this.mockRule("constraint1");
        scoreHolder.configureConstraintWeight(constraint1, SimpleLongScore.of((long)10L));
        Rule constraint2 = this.mockRule("constraint2");
        scoreHolder.configureConstraintWeight(constraint2, SimpleLongScore.of((long)100L));
        scoreHolder.penalize(this.mockRuleContext(constraint1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleLongScore.of((long)-10L));
        scoreHolder.penalize(this.mockRuleContext(constraint2, new Object[0]), 2L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleLongScore.of((long)-210L));
        scoreHolder = new SimpleLongScoreHolderImpl(constraintMatchEnabled);
        Rule constraint3 = this.mockRule("constraint3");
        scoreHolder.configureConstraintWeight(constraint3, SimpleLongScore.of((long)10L));
        Rule constraint4 = this.mockRule("constraint4");
        scoreHolder.configureConstraintWeight(constraint4, SimpleLongScore.of((long)100L));
        scoreHolder.reward(this.mockRuleContext(constraint3, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleLongScore.of((long)10L));
        scoreHolder.reward(this.mockRuleContext(constraint4, new Object[0]), 3L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleLongScore.of((long)310L));
    }
}

