/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolderTest;
import org.optaplanner.constraint.drl.holder.HardMediumSoftScoreHolderImpl;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.constraint.Indictment;

class HardMediumSoftScoreHolderImplTest
extends AbstractScoreHolderTest<HardMediumSoftScore> {
    HardMediumSoftScoreHolderImplTest() {
    }

    @Test
    void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        HardMediumSoftScoreHolderImpl scoreHolder = new HardMediumSoftScoreHolderImpl(constraintMatchEnabled);
        RuleContext hard1 = this.mockRuleContext("hard1", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard1, -1);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)-1, (int)0, (int)0));
        RuleContext hard2Undo = this.mockRuleContext("hard2Undo", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard2Undo, -8);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)-9, (int)0, (int)0));
        this.callOnDelete(hard2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)-1, (int)0, (int)0));
        RuleContext medium1 = this.mockRuleContext("medium1", new Object[0]);
        scoreHolder.addMediumConstraintMatch(medium1, -10);
        this.callOnUpdate(medium1);
        scoreHolder.addMediumConstraintMatch(medium1, -20);
        RuleContext soft1 = this.mockRuleContext("soft1", DEFAULT_JUSTIFICATION, OTHER_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft1, -100);
        this.callOnUpdate(soft1);
        scoreHolder.addSoftConstraintMatch(soft1, -300);
        RuleContext multi1 = this.mockRuleContext("multi1", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi1, -1000, -10000, -100000);
        this.callOnUpdate(multi1);
        scoreHolder.addMultiConstraintMatch(multi1, -4000, -50000, -600000);
        RuleContext hard3 = this.mockRuleContext("hard3", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard3, -1000000);
        this.callOnUpdate(hard3);
        scoreHolder.addHardConstraintMatch(hard3, -7000000);
        RuleContext soft2Undo = this.mockRuleContext("soft2Undo", UNDO_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft2Undo, -99);
        this.callOnDelete(soft2Undo);
        RuleContext multi2Undo = this.mockRuleContext("multi2Undo", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi2Undo, -999, -999, -999);
        this.callOnDelete(multi2Undo);
        RuleContext medium2Undo = this.mockRuleContext("medium2Undo", new Object[0]);
        scoreHolder.addMediumConstraintMatch(medium2Undo, -9999);
        this.callOnDelete(medium2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)-7004001, (int)-50020, (int)-600300));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(-7)).isEqualTo((Object)HardMediumSoftScore.ofUninitialized((int)-7, (int)-7004001, (int)-50020, (int)-600300));
        if (constraintMatchEnabled) {
            Assertions.assertThat((Comparable)((HardMediumSoftScore)this.findConstraintMatchTotal(scoreHolder, "hard1").getScore())).isEqualTo((Object)HardMediumSoftScore.of((int)-1, (int)0, (int)0));
            Assertions.assertThat((Comparable)((HardMediumSoftScore)((Indictment)scoreHolder.getIndictmentMap().get(OTHER_JUSTIFICATION)).getScore())).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)-300));
            Assertions.assertThat((Object)((Indictment)scoreHolder.getIndictmentMap().get(UNDO_JUSTIFICATION))).isNull();
        }
    }

    @Test
    void rewardPenalizeWithConstraintMatch() {
        this.rewardPenalize(true);
    }

    @Test
    void rewardPenalizeWithoutConstraintMatch() {
        this.rewardPenalize(false);
    }

    public void rewardPenalize(boolean constraintMatchEnabled) {
        HardMediumSoftScoreHolderImpl scoreHolder = new HardMediumSoftScoreHolderImpl(constraintMatchEnabled);
        Rule hard1 = this.mockRule("hard1");
        scoreHolder.configureConstraintWeight(hard1, HardMediumSoftScore.ofHard((int)10));
        Rule hard2 = this.mockRule("hard2");
        scoreHolder.configureConstraintWeight(hard2, HardMediumSoftScore.ofHard((int)100));
        Rule medium1 = this.mockRule("medium1");
        scoreHolder.configureConstraintWeight(medium1, HardMediumSoftScore.ofMedium((int)10));
        Rule soft1 = this.mockRule("soft1");
        scoreHolder.configureConstraintWeight(soft1, HardMediumSoftScore.ofSoft((int)10));
        Rule soft2 = this.mockRule("soft2");
        scoreHolder.configureConstraintWeight(soft2, HardMediumSoftScore.ofSoft((int)100));
        scoreHolder.penalize(this.mockRuleContext(hard1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)-10, (int)0, (int)0));
        scoreHolder.penalize(this.mockRuleContext(hard2, new Object[0]), 2);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)-210, (int)0, (int)0));
        scoreHolder.penalize(this.mockRuleContext(medium1, new Object[0]), 9);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)-210, (int)-90, (int)0));
        scoreHolder.reward(this.mockRuleContext(soft1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)-210, (int)-90, (int)10));
        scoreHolder.reward(this.mockRuleContext(soft2, new Object[0]), 3);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)-210, (int)-90, (int)310));
    }
}

