/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolderTest;
import org.optaplanner.constraint.drl.holder.HardSoftLongScoreHolderImpl;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.constraint.Indictment;

class HardSoftLongScoreHolderImplTest
extends AbstractScoreHolderTest<HardSoftLongScore> {
    HardSoftLongScoreHolderImplTest() {
    }

    @Test
    void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        HardSoftLongScoreHolderImpl scoreHolder = new HardSoftLongScoreHolderImpl(constraintMatchEnabled);
        RuleContext hard1 = this.mockRuleContext("hard1", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard1, -1L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)-1L, (long)0L));
        RuleContext hard2Undo = this.mockRuleContext("hard2Undo", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard2Undo, -8L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)-9L, (long)0L));
        this.callOnDelete(hard2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)-1L, (long)0L));
        RuleContext soft1 = this.mockRuleContext("soft1", DEFAULT_JUSTIFICATION, OTHER_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft1, -10L);
        this.callOnUpdate(soft1);
        scoreHolder.addSoftConstraintMatch(soft1, -20L);
        RuleContext multi1 = this.mockRuleContext("multi1", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi1, -100L, -1000L);
        this.callOnUpdate(multi1);
        scoreHolder.addMultiConstraintMatch(multi1, -300L, -4000L);
        RuleContext hard3 = this.mockRuleContext("hard3", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard3, -10000L);
        this.callOnUpdate(hard3);
        scoreHolder.addHardConstraintMatch(hard3, -50000L);
        RuleContext soft2Undo = this.mockRuleContext("soft2Undo", UNDO_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft2Undo, -99L);
        this.callOnDelete(soft2Undo);
        RuleContext multi2Undo = this.mockRuleContext("multi2Undo", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi2Undo, -999L, -999L);
        this.callOnDelete(multi2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)-50301L, (long)-4020L));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(-7)).isEqualTo((Object)HardSoftLongScore.ofUninitialized((int)-7, (long)-50301L, (long)-4020L));
        if (constraintMatchEnabled) {
            Assertions.assertThat((Comparable)((HardSoftLongScore)this.findConstraintMatchTotal(scoreHolder, "hard1").getScore())).isEqualTo((Object)HardSoftLongScore.of((long)-1L, (long)0L));
            Assertions.assertThat((Comparable)((HardSoftLongScore)((Indictment)scoreHolder.getIndictmentMap().get(OTHER_JUSTIFICATION)).getScore())).isEqualTo((Object)HardSoftLongScore.of((long)0L, (long)-20L));
            Assertions.assertThat((Object)((Indictment)scoreHolder.getIndictmentMap().get(UNDO_JUSTIFICATION))).isNull();
        }
    }

    @Test
    void rewardPenalizeWithConstraintMatch() {
        this.rewardPenalize(true);
    }

    @Test
    void rewardPenalizeWithoutConstraintMatch() {
        this.rewardPenalize(false);
    }

    public void rewardPenalize(boolean constraintMatchEnabled) {
        HardSoftLongScoreHolderImpl scoreHolder = new HardSoftLongScoreHolderImpl(constraintMatchEnabled);
        Rule hard1 = this.mockRule("hard1");
        scoreHolder.configureConstraintWeight(hard1, HardSoftLongScore.ofHard((long)10L));
        Rule hard2 = this.mockRule("hard2");
        scoreHolder.configureConstraintWeight(hard2, HardSoftLongScore.ofHard((long)100L));
        Rule soft1 = this.mockRule("soft1");
        scoreHolder.configureConstraintWeight(soft1, HardSoftLongScore.ofSoft((long)10L));
        Rule soft2 = this.mockRule("soft2");
        scoreHolder.configureConstraintWeight(soft2, HardSoftLongScore.ofSoft((long)100L));
        scoreHolder.penalize(this.mockRuleContext(hard1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)-10L, (long)0L));
        scoreHolder.penalize(this.mockRuleContext(hard2, new Object[0]), 2L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)-210L, (long)0L));
        scoreHolder.reward(this.mockRuleContext(soft1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)-210L, (long)10L));
        scoreHolder.reward(this.mockRuleContext(soft2, new Object[0]), 3L);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)-210L, (long)310L));
    }
}

