/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolderTest;
import org.optaplanner.constraint.drl.holder.HardSoftBigDecimalScoreHolderImpl;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.constraint.Indictment;

class HardSoftBigDecimalScoreHolderImplTest
extends AbstractScoreHolderTest<HardSoftBigDecimalScore> {
    HardSoftBigDecimalScoreHolderImplTest() {
    }

    @Test
    void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        HardSoftBigDecimalScoreHolderImpl scoreHolder = new HardSoftBigDecimalScoreHolderImpl(constraintMatchEnabled);
        RuleContext hard1 = this.mockRuleContext("hard1", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard1, new BigDecimal("-0.01"));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)new BigDecimal("-0.01"), (BigDecimal)new BigDecimal("0.00")));
        RuleContext hard2Undo = this.mockRuleContext("hard2Undo", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard2Undo, new BigDecimal("-0.08"));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)new BigDecimal("-0.09"), (BigDecimal)new BigDecimal("0.00")));
        this.callOnDelete(hard2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)new BigDecimal("-0.01"), (BigDecimal)new BigDecimal("0.00")));
        RuleContext soft1 = this.mockRuleContext("soft1", DEFAULT_JUSTIFICATION, OTHER_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft1, new BigDecimal("-0.10"));
        this.callOnUpdate(soft1);
        scoreHolder.addSoftConstraintMatch(soft1, new BigDecimal("-0.20"));
        RuleContext multi1 = this.mockRuleContext("multi1", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi1, new BigDecimal("-1.00"), new BigDecimal("-10.00"));
        this.callOnUpdate(multi1);
        scoreHolder.addMultiConstraintMatch(multi1, new BigDecimal("-3.00"), new BigDecimal("-40.00"));
        RuleContext hard3 = this.mockRuleContext("hard3", new Object[0]);
        scoreHolder.addHardConstraintMatch(hard3, new BigDecimal("-100.00"));
        this.callOnUpdate(hard3);
        scoreHolder.addHardConstraintMatch(hard3, new BigDecimal("-500.00"));
        RuleContext soft2Undo = this.mockRuleContext("soft2Undo", UNDO_JUSTIFICATION);
        scoreHolder.addSoftConstraintMatch(soft2Undo, new BigDecimal("-0.99"));
        this.callOnDelete(soft2Undo);
        RuleContext multi2Undo = this.mockRuleContext("multi2Undo", new Object[0]);
        scoreHolder.addMultiConstraintMatch(multi2Undo, new BigDecimal("-9.99"), new BigDecimal("-9.99"));
        this.callOnDelete(multi2Undo);
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)new BigDecimal("-503.01"), (BigDecimal)new BigDecimal("-40.20")));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(-7)).isEqualTo((Object)HardSoftBigDecimalScore.ofUninitialized((int)-7, (BigDecimal)new BigDecimal("-503.01"), (BigDecimal)new BigDecimal("-40.20")));
        if (constraintMatchEnabled) {
            Assertions.assertThat((Comparable)((HardSoftBigDecimalScore)this.findConstraintMatchTotal(scoreHolder, "hard1").getScore())).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)new BigDecimal("-0.01"), (BigDecimal)BigDecimal.ZERO));
            Assertions.assertThat((Comparable)((HardSoftBigDecimalScore)((Indictment)scoreHolder.getIndictmentMap().get(OTHER_JUSTIFICATION)).getScore())).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.ZERO, (BigDecimal)new BigDecimal("-0.20")));
            Assertions.assertThat((Object)((Indictment)scoreHolder.getIndictmentMap().get(UNDO_JUSTIFICATION))).isNull();
        }
    }

    @Test
    void rewardPenalizeWithConstraintMatch() {
        this.rewardPenalize(true);
    }

    @Test
    void rewardPenalizeWithoutConstraintMatch() {
        this.rewardPenalize(false);
    }

    public void rewardPenalize(boolean constraintMatchEnabled) {
        HardSoftBigDecimalScoreHolderImpl scoreHolder = new HardSoftBigDecimalScoreHolderImpl(constraintMatchEnabled);
        Rule hard1 = this.mockRule("hard1");
        scoreHolder.configureConstraintWeight(hard1, HardSoftBigDecimalScore.ofHard((BigDecimal)new BigDecimal("10.0")));
        Rule hard2 = this.mockRule("hard2");
        scoreHolder.configureConstraintWeight(hard2, HardSoftBigDecimalScore.ofHard((BigDecimal)new BigDecimal("100.0")));
        Rule soft1 = this.mockRule("soft1");
        scoreHolder.configureConstraintWeight(soft1, HardSoftBigDecimalScore.ofSoft((BigDecimal)new BigDecimal("10.0")));
        Rule soft2 = this.mockRule("soft2");
        scoreHolder.configureConstraintWeight(soft2, HardSoftBigDecimalScore.ofSoft((BigDecimal)new BigDecimal("100.0")));
        scoreHolder.penalize(this.mockRuleContext(hard1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)new BigDecimal("-10.0"), (BigDecimal)new BigDecimal("0.0")));
        scoreHolder.penalize(this.mockRuleContext(hard2, new Object[0]), new BigDecimal("2.0"));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)new BigDecimal("-210.0"), (BigDecimal)new BigDecimal("0.0")));
        scoreHolder.reward(this.mockRuleContext(soft1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)new BigDecimal("-210.0"), (BigDecimal)new BigDecimal("10.0")));
        scoreHolder.reward(this.mockRuleContext(soft2, new Object[0]), new BigDecimal("3.0"));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)new BigDecimal("-210.0"), (BigDecimal)new BigDecimal("310.0")));
    }
}

