/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolderTest;
import org.optaplanner.constraint.drl.holder.SimpleBigDecimalScoreHolderImpl;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;

class SimpleBigDecimalScoreHolderImplTest
extends AbstractScoreHolderTest<SimpleBigDecimalScore> {
    SimpleBigDecimalScoreHolderImplTest() {
    }

    @Test
    void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        SimpleBigDecimalScoreHolderImpl scoreHolder = new SimpleBigDecimalScoreHolderImpl(constraintMatchEnabled);
        RuleContext scoreRule1 = this.mockRuleContext("scoreRule1", new Object[0]);
        scoreHolder.addConstraintMatch(scoreRule1, new BigDecimal("-10.00"));
        RuleContext scoreRule2 = this.mockRuleContext("scoreRule2", new Object[0]);
        scoreHolder.addConstraintMatch(scoreRule2, new BigDecimal("-2.00"));
        this.callOnDelete(scoreRule2);
        RuleContext scoreRule3 = this.mockRuleContext("scoreRule3", new Object[0]);
        scoreHolder.addConstraintMatch(scoreRule3, new BigDecimal("-0.30"));
        this.callOnUpdate(scoreRule3);
        scoreHolder.addConstraintMatch(scoreRule3, new BigDecimal("-0.03"));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleBigDecimalScore.ofUninitialized((int)0, (BigDecimal)new BigDecimal("-10.03")));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(-7)).isEqualTo((Object)SimpleBigDecimalScore.ofUninitialized((int)-7, (BigDecimal)new BigDecimal("-10.03")));
        if (constraintMatchEnabled) {
            Assertions.assertThat((Comparable)((SimpleBigDecimalScore)this.findConstraintMatchTotal(scoreHolder, "scoreRule1").getScore())).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("-10.00")));
        }
    }

    @Test
    void rewardPenalizeWithConstraintMatch() {
        this.rewardPenalize(true);
    }

    @Test
    void rewardPenalizeWithoutConstraintMatch() {
        this.rewardPenalize(false);
    }

    public void rewardPenalize(boolean constraintMatchEnabled) {
        SimpleBigDecimalScoreHolderImpl scoreHolder = new SimpleBigDecimalScoreHolderImpl(constraintMatchEnabled);
        Rule constraint1 = this.mockRule("constraint1");
        scoreHolder.configureConstraintWeight(constraint1, SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("10.0")));
        Rule constraint2 = this.mockRule("constraint2");
        scoreHolder.configureConstraintWeight(constraint2, SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("100.0")));
        scoreHolder.penalize(this.mockRuleContext(constraint1, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("-10.0")));
        scoreHolder.penalize(this.mockRuleContext(constraint2, new Object[0]), new BigDecimal("2.0"));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("-210.0")));
        scoreHolder = new SimpleBigDecimalScoreHolderImpl(constraintMatchEnabled);
        Rule constraint3 = this.mockRule("constraint3");
        scoreHolder.configureConstraintWeight(constraint3, SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("10.0")));
        Rule constraint4 = this.mockRule("constraint4");
        scoreHolder.configureConstraintWeight(constraint4, SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("100.0")));
        scoreHolder.reward(this.mockRuleContext(constraint3, new Object[0]));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("10.0")));
        scoreHolder.reward(this.mockRuleContext(constraint4, new Object[0]), new BigDecimal("3.0"));
        Assertions.assertThat((Comparable)scoreHolder.extractScore(0)).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("310.0")));
    }
}

