/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.tri;

import java.util.Set;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.common.index.JoinerUtils;
import org.optaplanner.constraint.streams.bavet.tri.BavetAbstractTriConstraintStream;
import org.optaplanner.constraint.streams.bavet.tri.IfExistsTriWithUniNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetIfExistsBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.constraint.streams.common.quad.DefaultQuadJoiner;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

final class BavetIfExistsTriConstraintStream<Solution_, A, B, C, D>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C> {
    private final BavetAbstractTriConstraintStream<Solution_, A, B, C> parentABC;
    private final BavetIfExistsBridgeUniConstraintStream<Solution_, D> parentBridgeD;
    private final boolean shouldExist;
    private final DefaultQuadJoiner<A, B, C, D> joiner;
    private final QuadPredicate<A, B, C, D> filtering;

    public BavetIfExistsTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parentABC, BavetIfExistsBridgeUniConstraintStream<Solution_, D> parentBridgeD, boolean shouldExist, DefaultQuadJoiner<A, B, C, D> joiner, QuadPredicate<A, B, C, D> filtering) {
        super(constraintFactory, parentABC.getRetrievalSemantics());
        this.parentABC = parentABC;
        this.parentBridgeD = parentBridgeD;
        this.shouldExist = shouldExist;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    public boolean guaranteesDistinct() {
        return this.parentABC.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parentABC.collectActiveConstraintStreams(constraintStreamSet);
        this.parentBridgeD.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this.parentABC.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int inputStoreIndexA = buildHelper.reserveTupleStoreIndex(this.parentABC.getTupleSource());
        int inputStoreIndexB = buildHelper.reserveTupleStoreIndex(this.parentBridgeD.getTupleSource());
        Consumer insert = buildHelper.getAggregatedInsert(this.childStreamList);
        Consumer retract = buildHelper.getAggregatedRetract(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory((AbstractJoiner)this.joiner);
        Indexer indexerAB = indexerFactory.buildIndexer(true);
        Indexer indexerC = indexerFactory.buildIndexer(false);
        IfExistsTriWithUniNode node = new IfExistsTriWithUniNode(this.shouldExist, JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), inputStoreIndexA, inputStoreIndexB, insert, retract, indexerAB, indexerC, this.filtering);
        buildHelper.addNode(node);
        buildHelper.putInsertUpdateRetract((ConstraintStream)this, node::insertLeft, node::updateLeft, node::retractLeft);
        buildHelper.putInsertUpdateRetract((ConstraintStream)this.parentBridgeD, node::insertRight, node::updateRight, node::retractRight);
    }

    public String toString() {
        return "IfExists() with " + this.childStreamList.size() + " children";
    }
}

