/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.tri;

import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.common.Group;
import org.optaplanner.constraint.streams.bavet.tri.AbstractGroupTriNode;
import org.optaplanner.constraint.streams.bavet.tri.TriTuple;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.impl.util.Triple;

final class Group3Mapping0CollectorTriNode<OldA, OldB, OldC, A, B, C>
extends AbstractGroupTriNode<OldA, OldB, OldC, TriTuple<A, B, C>, Triple<A, B, C>, Void, Void> {
    private final TriFunction<OldA, OldB, OldC, A> groupKeyMappingA;
    private final TriFunction<OldA, OldB, OldC, B> groupKeyMappingB;
    private final TriFunction<OldA, OldB, OldC, C> groupKeyMappingC;
    private final int outputStoreSize;

    public Group3Mapping0CollectorTriNode(TriFunction<OldA, OldB, OldC, A> groupKeyMappingA, TriFunction<OldA, OldB, OldC, B> groupKeyMappingB, TriFunction<OldA, OldB, OldC, C> groupKeyMappingC, int groupStoreIndex, Consumer<TriTuple<A, B, C>> nextNodesInsert, Consumer<TriTuple<A, B, C>> nextNodesRetract, int outputStoreSize) {
        super(groupStoreIndex, null, nextNodesInsert, nextNodesRetract);
        this.groupKeyMappingA = groupKeyMappingA;
        this.groupKeyMappingB = groupKeyMappingB;
        this.groupKeyMappingC = groupKeyMappingC;
        this.outputStoreSize = outputStoreSize;
    }

    @Override
    protected Triple<A, B, C> createGroupKey(TriTuple<OldA, OldB, OldC> tuple) {
        Object oldA = tuple.factA;
        Object oldB = tuple.factB;
        Object oldC = tuple.factC;
        Object a = this.groupKeyMappingA.apply(oldA, oldB, oldC);
        Object b = this.groupKeyMappingB.apply(oldA, oldB, oldC);
        Object c = this.groupKeyMappingC.apply(oldA, oldB, oldC);
        return Triple.of((Object)a, (Object)b, (Object)c);
    }

    @Override
    protected TriTuple<A, B, C> createOutTuple(Group<TriTuple<A, B, C>, Triple<A, B, C>, Void> group) {
        Triple key = (Triple)group.groupKey;
        return new TriTuple<Object, Object, Object>(key.getA(), key.getB(), key.getC(), this.outputStoreSize);
    }

    public String toString() {
        return "GroupTriNode 3+0";
    }
}

