/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.AbstractInserter;
import org.optaplanner.constraint.streams.bavet.common.AbstractUpdater;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetFilterUniConstraintStream<Solution_, A>
extends BavetAbstractUniConstraintStream<Solution_, A> {
    private final BavetAbstractUniConstraintStream<Solution_, A> parent;
    private final Predicate<A> predicate;

    public BavetFilterUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, Predicate<A> predicate) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        this.predicate = predicate;
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate (null) cannot be null.");
        }
    }

    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this.parent.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        buildHelper.putInsertUpdateRetract((ConstraintStream)this, this.childStreamList, insert -> new ConditionalUniInserter<A>(this.predicate, insert), (update, retract) -> new ConditionalUniUpdater<A>(this.predicate, update, retract));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parent, this.predicate});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFilterUniConstraintStream) {
            BavetFilterUniConstraintStream other = (BavetFilterUniConstraintStream)((Object)o);
            return this.parent == other.parent && this.predicate == other.predicate;
        }
        return false;
    }

    public String toString() {
        return "Filter() with " + this.childStreamList.size() + " children";
    }

    private static final class ConditionalUniUpdater<A>
    extends AbstractUpdater<UniTuple<A>> {
        private final Predicate<A> predicate;

        public ConditionalUniUpdater(Predicate<A> predicate, Consumer<UniTuple<A>> update, Consumer<UniTuple<A>> retract) {
            super(update, retract);
            this.predicate = predicate;
        }

        @Override
        protected boolean test(UniTuple<A> tuple) {
            return this.predicate.test(tuple.factA);
        }
    }

    private static final class ConditionalUniInserter<A>
    extends AbstractInserter<UniTuple<A>> {
        private final Predicate<A> predicate;

        public ConditionalUniInserter(Predicate<A> predicate, Consumer<UniTuple<A>> insert) {
            super(insert);
            this.predicate = predicate;
        }

        @Override
        protected boolean test(UniTuple<A> tuple) {
            return this.predicate.test(tuple.factA);
        }
    }
}

