/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.AbstractIndexerTest;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.NoneIndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.NoneIndexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

class NoneIndexerTest
extends AbstractIndexerTest {
    NoneIndexerTest() {
    }

    @Test
    void getEmpty() {
        NoneIndexer indexer = new NoneIndexer();
        Assertions.assertThat(this.getTupleMap(indexer, new Object[0])).isEmpty();
    }

    @Test
    void putTwice() {
        NoneIndexer indexer = new NoneIndexer();
        UniTuple<String> annTuple = NoneIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, annTuple, (Object)"Ann value");
        Assertions.assertThatThrownBy(() -> NoneIndexerTest.lambda$putTwice$0((Indexer)indexer, annTuple)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void removeTwice() {
        NoneIndexer indexer = new NoneIndexer();
        UniTuple<String> annTuple = NoneIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, annTuple, (Object)"Ann value");
        UniTuple<String> ednaTuple = NoneIndexerTest.newTuple("Edna-F-40");
        Assertions.assertThatThrownBy(() -> NoneIndexerTest.lambda$removeTwice$1((Indexer)indexer, ednaTuple)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThat((String)((String)indexer.remove((IndexProperties)NoneIndexProperties.INSTANCE, annTuple))).isEqualTo("Ann value");
        Assertions.assertThatThrownBy(() -> NoneIndexerTest.lambda$removeTwice$2((Indexer)indexer, annTuple)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void visit() {
        NoneIndexer indexer = new NoneIndexer();
        UniTuple<String> annTuple = NoneIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, annTuple, (Object)"Ann value");
        UniTuple<String> bethTuple = NoneIndexerTest.newTuple("Beth-F-30");
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, bethTuple, (Object)"Beth value");
        Assertions.assertThat(this.getTupleMap(indexer, new Object[0])).containsOnlyKeys((Object[])new UniTuple[]{annTuple, bethTuple});
    }

    private static UniTuple<String> newTuple(String factA) {
        return new UniTuple((Object)factA, 0);
    }

    private static /* synthetic */ void lambda$removeTwice$2(Indexer indexer, UniTuple annTuple) throws Throwable {
        indexer.remove((IndexProperties)NoneIndexProperties.INSTANCE, (Tuple)annTuple);
    }

    private static /* synthetic */ void lambda$removeTwice$1(Indexer indexer, UniTuple ednaTuple) throws Throwable {
        indexer.remove((IndexProperties)NoneIndexProperties.INSTANCE, (Tuple)ednaTuple);
    }

    private static /* synthetic */ void lambda$putTwice$0(Indexer indexer, UniTuple annTuple) throws Throwable {
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, (Tuple)annTuple, (Object)"Ann value");
    }
}

